/*
 * $RCSfile: MBXmiResourceFactory.java,v $
 * $Date: 2006/03/15 14:00:24 $
 * $Revision: 1.3 $
 * $Author: xblanc $
 */
 
/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */
 
/*
 * ModelBusResourceFactory.java
 * 
 * @author Prawee Sriplakich
 * @version $Revision: 1.3 $ $Date: 2006/03/15 14:00:24 $
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.modelbus_xmi;

import java.util.Map;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;



public class MBXmiResourceFactory implements Resource.Factory {

    private static Logger logger = Logger.getLogger(MBXmiResourceFactory.class);
    
    public static final String EXTENSION = "mb_xmi";
    
    public Resource createResource(URI uri) {
        return new MBXmiResource(uri);
    }
    
    public static void init() {
        Map m = Resource.Factory.Registry.INSTANCE
        .getExtensionToFactoryMap();
        m.put(EXTENSION, new MBXmiResourceFactory());        
    }

}
