/*
 * $RCSfile: ProfiledModelSerializer.java,v $
 * $Date: 2006/05/26 12:53:05 $
 * $Revision: 1.6 $
 * $Author: xblanc $
 */
 
/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */
 
/*
 * ProfiledModelSerializer.java
 * 
 * @author Prawee Sriplakich
 * @version $Revision: 1.6 $ $Date: 2006/05/26 12:53:05 $
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.uml2;

import java.io.ByteArrayInputStream;
import java.util.*;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelBusResourceSet;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.uml2.Uml2ModelUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.DeserializedModel;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.SerializedXmiDocument;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.emf_xmi.DefaultModelSerializer;
import org.eclipse.mddi.modelbus.description.abstract_.Parameter;
import org.eclipse.uml2.Profile;
import org.eclipse.uml2.UML2Package;

/**
 * This class can serialize and deserialize UML2 models
 * and the UML2 profiles that are applied to those models 
 * <br>
 * When the profiles are deserialized, 
 * their EPackages are automatically registered with EMF.
 * This enable the models (to which the profiles are applied) 
 * to be deserialized without error.
 * 
 * @author P. Sriplakich
 *
 *
 */
public class ProfiledModelSerializer extends DefaultModelSerializer {

    private static Logger logger = Logger.getLogger(ProfiledModelSerializer.class);
    
    
    /**
     * 
     */
    public ProfiledModelSerializer() {
        super();
        ignoredUriPrefixSet.add("pathmap://UML2_PROFILES"); 
        ignoredUriPrefixSet.add("pathmap://UML2_LIBRARIES");  
        ignoredUriPrefixSet.add("pathmap://UML2_METAMODELS");
    }    
    
    /*
     * implements ModelSerializer 
     */
    public SerializedXmiDocument[] serialize(Parameter[] params, Object[] values) {
        Collection allModelElements = getScope(params, values);
        Resource[] res = ModelUtil.getResourcesFromObjects(allModelElements,
                skipCrossReferences, ignoredUriPrefixSet);
        
        ////////////////////////////
        List list = new Vector(Arrays.asList(res));
        for(int i=0; i<res.length; i++) {
            res[i] = getProfileResourceFirst(list);
        }
        ///////////////////////////////
        
        return serializeResources(res);
    }

    /*
     * implements ModelSerializer 
     */
    public DeserializedModel[] deserialize(SerializedXmiDocument[] documents) {
        DeserializedModel[] result = new DeserializedModel[documents.length];
        ResourceSet rs = new ModelBusResourceSet();
        
        for(int i=0; i<documents.length; i++) {
            result[i] = new DeserializedModel();
            result[i].setUri( documents[i].getUri() );
            try {
               ByteArrayInputStream bin = new ByteArrayInputStream( 
                        documents[i].getXmi().getBytes() );               
               Resource r = rs.createResource( 
                       URI.createURI(documents[i].getUri()) ); 
               r.load(bin, null);
               result[i].setValue(r);
               
               ///////////////////////////////////////////// 
               Profile p = getContainedProfile(r);
               if(p!=null) {
                 Uml2ModelUtil.registerEcorePackagesOfProfile(p);
               }               
               ////////////////////////////////////////// 
               
            } catch(Exception e) {
                logger.error(e);
            }
        }
        return result;
    }  
    
    /**
     * 
     * Each time it is called,
     * a resource is removed from the collection
     * and returned.
     * If the collection contains resources representing profiles,
     * those resources will be returned first.
     * 
     * @param v
     * @return
     * 
     *
     */
    Resource getProfileResourceFirst(Collection c) {
        Resource r;
        for(Iterator it = c.iterator(); it.hasNext(); ) {
          r = (Resource) it.next();
          Profile p = getContainedProfile(r);
          if(p!=null) {
              c.remove(r);
              return r;
          }
        }
        if(c.isEmpty()) return null;
        r = (Resource) c.iterator().next();
        c.remove(r);
        return r;
    }
    
    
    public static Profile getContainedProfile(Resource r) {
        Profile profile = (Profile) EcoreUtil.getObjectByType(
                r.getContents(), UML2Package.eINSTANCE.getProfile());
        return profile;
    }
    
    
    
    
    
}
