/*
 * $RCSfile: SessionProviderProxy.java,v $
 * $Date: 2006/07/07 15:15:49 $
 * $Revision: 1.4 $
 * $Author: xblanc $
 */
 
/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */
 
/*
 * SessionProviderProxy.java
 * 
 * @author Andrey Sadovykh (LIP6)
 * @version $Revision: 1.4 $ $Date: 2006/07/07 15:15:49 $
 * @see Add references
 *
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport;

import org.eclipse.mddi.modelbus.adapter.user.ModelingServiceError;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelBusCommunicationException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelTypeMismatchException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.NoToolAvailableException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ServiceUnknownException;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingService;

public interface SessionProviderProxy extends ProviderProxy {

/**
 * 
 * setSessionManager Add description 
 * 
 * @param sessionManager
 *
 */
    public void setSessionManager(SessionManager sessionManager);
    
    public String newSession() throws ModelBusCommunicationException;
    public void endSession(String sessionId) throws ModelBusCommunicationException;
    
    /**
     * 
     * Open sessions for this proxy 
     * 
     * @return
     *
     */
    public String[] getOpenSessions();
    
 
    public Object[] invoke(ModelingService ms,
            Object[] inputs, String sessionID) throws ServiceUnknownException,
            NoToolAvailableException, ModelTypeMismatchException,
            ModelBusCommunicationException, ModelingServiceError;  
    
    /**
     * 
     * invokeAsync service invokation in an asynchronous manner
     * 
     * @param ms
     * @param inputs
     * @param sessionID
     * @return
     * @throws ServiceUnknownException
     * @throws NoToolAvailableException
     * @throws ModelTypeMismatchException
     * @throws ModelBusCommunicationException
     * @throws ModelingServiceError
     *
     */
    
    public String invokeAsync(ModelingService ms,
            Object[] inputs, String sessionID) throws ServiceUnknownException,
            NoToolAvailableException, ModelTypeMismatchException,
            ModelBusCommunicationException, ModelingServiceError;    

    
}
