/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * Created on 16 juin 2005
 *
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws;

import javax.xml.soap.SOAPEnvelope;

/**
 * This interface is used for an HTTP server to dispatch requests to services
 * that are responsible for processing them.
 * 
 * @author Prawee Sriplakich, Andrey Sadovykh (LIP6)
 *
 *
 */
public interface EndPoint {
    
    /**
     * Dispatches requests to corresponding services
     * 
     * @param uri URI of the HTTP request. For example, objecteering/services/loadUmlModel
     * @param request SOAP message containing input parameter values
     * @param response SOAP message for response. The content will be filled by the service
     * @throws Exception Produced if errors occur during service execution
     */
    public void execute(String relativePath, SOAPEnvelope req, SOAPEnvelope resp) throws javax.xml.soap.SOAPException ;
    

}
