/*
 * $RCSfile: EndPointManagerImpl.java,v $ $Date: 2006/03/14 18:10:08 $
 * $Revision: 1.3 $ $Author: xblanc $
 */

/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus. All rights
 * reserved.
 * 
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * EndPointManagerImpl.java
 * 
 * @author Prawee Sriplakich
 * 
 * @version $Revision: 1.3 $ $Date: 2006/03/14 18:10:08 $
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;

import org.apache.log4j.Logger;

public class EndPointManagerImpl implements EndPointManager {

    private static Logger logger = Logger.getLogger(EndPointManagerImpl.class);

    private static EndPointManager endPointManager = new EndPointManagerImpl();

    public static EndPointManager getInstance() {
        return endPointManager;
    }

    Map endPointMap = new Hashtable(); //stores endpoints according to
                                       // incomplete relative path

    public EndPoint getEndPoint(String relativePath) {
        for (Iterator it = endPointMap.keySet().iterator(); it.hasNext();) {
            String incompleteRelativePath = (String) it.next();
            if (relativePath.startsWith(incompleteRelativePath)) {
                return (EndPoint) endPointMap.get(incompleteRelativePath);
            }
        }
        return null;
    }

    public void putEndPoint(String incompleteRelativePath, EndPoint endPoint) {
        endPointMap.put(incompleteRelativePath, endPoint);
        logger.debug("add path:"+incompleteRelativePath);
    }

    public void execute(String urlPath, SOAPEnvelope req, SOAPEnvelope resp) {
        EndPoint ep = getEndPoint(urlPath);
        if (ep != null) {
            try {
                ep.execute(urlPath, req, resp);
            } catch (SOAPException e) {
                e.printStackTrace();
            }
        } else {
            logger.debug("not EndPoint for url path : " + urlPath);

        }
    }

    /* (non-Javadoc)
     * @see org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.EndPointManager#removeEndPoint(java.lang.String)
     */
    public void removeEndPoint(String incompleteRelativePath) {
        endPointMap.remove(incompleteRelativePath);
        logger.debug("del path:"+incompleteRelativePath);
        
        logger.debug("points empty:"+endPointMap.isEmpty());
        if (endPointMap.isEmpty()) {
            ServerManager.getInstance().shutdown();
        }
        
    }
}
