/*
 * $RCSfile: ServerManager.java,v $
 * $Date: 2006/03/14 18:10:08 $
 * $Revision: 1.3 $
 * $Author: xblanc $
 */
 
/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */
 
/*
 * ServerManager.java 
 * 
 * @author Prawee Sriplakich
 * @version $Revision: 1.3 $ $Date: 2006/03/14 18:10:08 $
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws;

import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import org.apache.log4j.Logger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.AdapterContainerImpl;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.AbstractServer;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.axis.SimpleModelBusServer;
import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;

public class ServerManager {
    
    public static final String DEFAULT_CONTEXT = "modelbus";
    
    public static int DEFAULT_MB_PORT = 8081;    
    
    static ServerManager instance = new ServerManager();
    private static Logger logger = Logger.getLogger(ServerManager.class);    
    
    public static ServerManager getInstance() {  return instance; }
    
    ServerManager() {
        
    }
    
    Set servers = new HashSet();


    
    /**
     * 
     * put Server to be managed.
     * It will be immediately started
     * 
     * @param port
     * @param s
     * @throws Exception if the server can not start
     * 
     *
     */
    public void putServer(AbstractServer s) {
        if(servers.contains(s)) {
            return;
        } else {
          servers.add(s);        
          s.setEndPointManager(EndPointManagerImpl.getInstance());
        }
    }
    
    /**
     * 
     * create Server on the specified port and start it. 
     * If a server already exists, do nothing
     * 
     * @param port
     * @throws Exception
     * 
     *
     */
    public AbstractServer getServer(int port) throws Exception {
        for(Iterator it= servers.iterator(); it.hasNext();){
            AbstractServer test= (AbstractServer) it.next();
            if (test.getPort()==port) return test;
        }
        AbstractServer s = null;
        s = new SimpleModelBusServer(port);     
        putServer(s);
        return s;
    }

    public static String getHost() {
        try {
            return java.net.InetAddress.getLocalHost().getHostAddress().toString();
        } catch (UnknownHostException e) {
            logger.error("The host is not connected to internet");
            return "localhost";
        }
        
    }

    public static int getModelBusPort(AdapterStub adapter) {
        String portString = adapter.getProperties().getProperty(AdapterStub.MODELBUS_PORT);
        if(portString!=null) {
            try {
                int port = Integer.parseInt(portString);
                return port;
            } catch(NumberFormatException e) {
                AdapterContainerImpl.logger.error("Adapter. bad PROP_MODELBUS_PORT (" +portString 
                        +"). used default (" + DEFAULT_MB_PORT +")" );
            }            
        } 
        return DEFAULT_MB_PORT;
    }
    
   public void shutdown(){
       for(Iterator it= servers.iterator(); it.hasNext();){
           SimpleModelBusServer test= (SimpleModelBusServer) it.next();
           test.stop();
       }
       servers.clear();
       logger.info("The server is shutdown.");
       
   }

}
