/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * Created on 22 juil. 2005
 *
 */
package org.eclipse.mddi.modelbus.adapter.user;

import org.apache.axis.AxisFault;
import org.eclipse.mddi.modelbus.description.abstract_.Error;

/**
 * This class represents an error that is produced by the provider tools during
 * service execution. This error must conform to the Error metaclass instance
 * defined in the tool description. Please refer to the tool description
 * metamodel.
 * 
 * @author Prawee Sriplakich (LIP6)
 * 
 *  
 */
public class ModelingServiceError extends Exception {

    /**
     *  
     */
    private static final long serialVersionUID = -5134134489369713196L;

    /**
     * The name of the error.
     * 
     * @see org.eclipse.mddi.modelbus.description.abstract_.Error
     */
    String name;

    /**
     * The information contained by the error. This information can be either
     * primitive data or model. Its type must correspond to the error type
     * defined in the tool description.
     * 
     * @see org.eclipse.mddi.modelbus.description.abstract_.Error
     */
    Object info;

    /**
     * The information about Error including InfoObject type and its
     * multiplicity, it can be traced from a Tool Description
     * 
     * @see org.eclipse.mddi.modelbus.description.abstract_.Error
     */
    Error errorType = null;

    public ModelingServiceError(String _name, Object _info) {
        name = _name;
        info = _info;
    }

    public ModelingServiceError(Error _errorType, Object _info) {
        errorType = _errorType;
        name = _errorType.getName();
        info = _info;
    }

    /**
     * @return Returns the name.
     */
    public String getName() {
        return name;
    }

    /**
     * @param name
     *            The name to set.
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * @return Returns the info.
     */
    public Object getInfo() {
        return info;
    }

    /**
     * @param info
     *            The info to set.
     */
    public void setInfo(Object info) {
        this.info = info;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Throwable#getMessage()
     */
    public String getMessage() {
        return name;
    }

    /**
     * @return Returns the errorType.
     */
    public Error getErrorType() {
        return errorType;
    }
    /**
     * @param errorType The errorType to set.
     */
    public void setErrorType(Error errorType) {
        this.errorType = errorType;
        this.name = errorType.getName();
    }
}
