/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.merge;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.MergeHelper;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Create;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Delete;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Delta;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.InsertLink;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Merge;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.MergeFactory;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.MergePackage;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ModifyLink;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ModifyPrimitive;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ModifyProp;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.NodeLevelSubDelta;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.RemoveLink;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.impl.MergePackageImpl;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.util.Diff;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.util.Difference;

public class DeltaCalculation {
    static Logger logger = Logger.getLogger((String)"DeltaCalculation");
    static MergeFactory fac;

    static {
        try {
            MergePackageImpl.init();
            fac = (MergeFactory)MergePackage.eINSTANCE.getEFactoryInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Delta diff(Resource base, Resource variant) {
        Internal internal = new Internal();
        return internal.diff(base, variant);
    }

    public static Merge diff3(Resource base, Resource localVariant, Resource remoteVariant) {
        Merge m = fac.createMerge();
        m.setResourceURL(localVariant.getURI().toString());
        Delta localDelta = DeltaCalculation.diff(base, localVariant);
        m.setLocalDelta(localDelta);
        Delta remoteDelta = DeltaCalculation.diff(base, remoteVariant);
        m.setRemoteDelta(remoteDelta);
        return m;
    }

    public static class Internal {
        Collection newIds;
        Collection deletedIds;
        Collection commonIds;

        public Delta diff(Resource base, Resource variant) {
            ModifyProp modprop;
            EStructuralFeature f;
            Iterator it2;
            EList features;
            String id;
            Delta d = fac.createDelta();
            this.newIds = MergeHelper.getExtraElements(base, variant);
            Iterator it = this.newIds.iterator();
            while (it.hasNext()) {
                id = (String)it.next();
                EObject newNode = variant.getEObject(id);
                Create create = fac.createCreate();
                EClass clazz = newNode.eClass();
                create.setType(clazz);
                create.setId(id);
                d.getContent().add((Object)create);
                features = clazz.getEAllStructuralFeatures();
                it2 = features.iterator();
                while (it2.hasNext()) {
                    f = (EStructuralFeature)it2.next();
                    modprop = this.calculatePropertySetting(f, newNode);
                    if (modprop == null) continue;
                    create.getContent().add((Object)modprop);
                }
            }
            this.deletedIds = MergeHelper.getExtraElements(variant, base);
            it = this.deletedIds.iterator();
            while (it.hasNext()) {
                id = (String)it.next();
                fac.createDelete();
                Delete delete = fac.createDelete();
                delete.setId(id);
                d.getContent().add((Object)delete);
            }
            this.commonIds = MergeHelper.getCommonElements(base, variant);
            it = this.commonIds.iterator();
            while (it.hasNext()) {
                id = (String)it.next();
                NodeLevelSubDelta mod = null;
                EObject oldNode = base.getEObject(id);
                EObject newNode = variant.getEObject(id);
                features = oldNode.eClass().getEAllStructuralFeatures();
                it2 = features.iterator();
                while (it2.hasNext()) {
                    f = (EStructuralFeature)it2.next();
                    modprop = this.calculatePropertyChange(f, oldNode, newNode);
                    if (modprop == null) continue;
                    if (mod == null) {
                        mod = fac.createModifyExisting();
                        mod.setId(id);
                        d.getContent().add((Object)mod);
                    }
                    mod.getContent().add((Object)modprop);
                }
            }
            return d;
        }

        public ModifyProp calculatePropertySetting(EStructuralFeature f, EObject newNode) {
            if (!MergeHelper.needsComparison(f)) {
                return null;
            }
            Object v = newNode.eGet(f);
            if (v == null || v instanceof Collection && ((Collection)v).isEmpty()) {
                return null;
            }
            if (f instanceof EAttribute) {
                EAttribute a = (EAttribute)f;
                ModifyPrimitive modprim = fac.createModifyPrimitive();
                modprim.setProperty(f);
                String s = MergeHelper.serializeValue(a.getEAttributeType(), v);
                modprim.setValue(s);
                return modprim;
            }
            ModifyLink modl = fac.createModifyLink();
            modl.setProperty(f);
            InsertLink insert = fac.createInsertLink();
            modl.getInsert().add((Object)insert);
            if (v instanceof Collection) {
                List ids = MergeHelper.getIDList((Collection)v);
                insert.getRef().addAll((Collection)ids);
            } else if (v != null) {
                String id = MergeHelper.getURIFragment((EObject)v);
                insert.getRef().add((Object)id);
            }
            return modl;
        }

        public ModifyProp calculatePropertyChange(EStructuralFeature f, EObject oldNode, EObject newNode) {
            if (!MergeHelper.needsComparison(f)) {
                return null;
            }
            Object oldValue = oldNode.eGet(f);
            Object newValue = newNode.eGet(f);
            if (f instanceof EAttribute) {
                EAttribute a = (EAttribute)f;
                if (MergeHelper.areDiffrent(oldValue, newValue)) {
                    ModifyPrimitive mod = fac.createModifyPrimitive();
                    mod.setProperty(f);
                    String s = MergeHelper.serializeValue(a.getEAttributeType(), newValue);
                    mod.setValue(s);
                    return mod;
                }
            } else {
                return this.calculateLinkChange((EReference)f, oldValue, newValue);
            }
            return null;
        }

        public ModifyLink calculateLinkChange(EReference r, Object oldValue, Object newValue) {
            if (!MergeHelper.doesLinkChange(r, oldValue, newValue)) {
                return null;
            }
            ModifyLink mod = fac.createModifyLink();
            mod.setProperty((EStructuralFeature)r);
            if (r.isMany()) {
                List baseRefValue = MergeHelper.getIDList((Collection)oldValue);
                List variantRefValue = MergeHelper.getIDList((Collection)newValue);
                this.calculateRemoveLink(mod, baseRefValue, variantRefValue);
                this.calculateInsertLink(r, mod, baseRefValue, variantRefValue);
            } else {
                String id;
                if (oldValue != null) {
                    RemoveLink rl = fac.createRemoveLink();
                    mod.setRemove(rl);
                    id = MergeHelper.getURIFragment((EObject)oldValue);
                    rl.getRef().add((Object)id);
                }
                if (newValue != null) {
                    InsertLink il = fac.createInsertLink();
                    mod.getInsert().add((Object)il);
                    id = MergeHelper.getURIFragment((EObject)newValue);
                    il.getRef().add((Object)id);
                }
            }
            if (mod.getRemove() == null && mod.getInsert().isEmpty()) {
                return null;
            }
            return mod;
        }

        public void calculateRemoveLink(ModifyLink mod, List base, List variant) {
            Vector removedRef = new Vector(base);
            removedRef.removeAll(variant);
            removedRef.removeAll(this.deletedIds);
            if (!removedRef.isEmpty()) {
                RemoveLink rl = fac.createRemoveLink();
                rl.getRef().addAll(removedRef);
                mod.setRemove(rl);
            }
        }

        public void calculateInsertLink(EReference r, ModifyLink mod, List baseRefValue, List variantRefValue) {
            if (r.isOrdered()) {
                Vector basePropertyValue = new Vector(baseRefValue);
                basePropertyValue.retainAll(variantRefValue);
                this.calculateOrderredInsertLinks(mod, basePropertyValue, variantRefValue);
            } else {
                HashSet addedRef = new HashSet();
                addedRef.addAll(variantRefValue);
                addedRef.removeAll(baseRefValue);
                if (!addedRef.isEmpty()) {
                    InsertLink il = fac.createInsertLink();
                    il.getRef().addAll(addedRef);
                    mod.getInsert().add((Object)il);
                }
            }
        }

        public void calculateOrderredInsertLinks(ModifyLink mod, List base, List variant) {
            Diff diff = new Diff(base, variant);
            List diffItems = diff.diff();
            Iterator it = diffItems.iterator();
            while (it.hasNext()) {
                Difference item = (Difference)it.next();
                if (item.getAddedEnd() == -1) continue;
                List addedRef = variant.subList(item.getAddedStart(), item.getAddedEnd() + 1);
                InsertLink il = fac.createInsertLink();
                il.getRef().addAll(addedRef);
                int posAfter = item.getDeletedStart() - 1;
                if (posAfter != -1) {
                    String idAfter = (String)base.get(posAfter);
                    il.setPosAfter(idAfter);
                }
                mod.getInsert().add((Object)il);
            }
        }
    }
}

