/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.merge;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Create;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Delete;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Delta;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.InsertLink;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Merge;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.MergeFactory;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.MergePackage;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ModifyLink;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ModifyLinkElement;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ModifyPrimitive;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ModifyProp;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.NodeLevelSubDelta;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.RemoveLink;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.SubDelta;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.impl.MergePackageImpl;

public class DeltaQuery {
    static Logger logger = Logger.getLogger((String)"DeltaQuery");
    static MergeFactory fac;
    protected Delta delta;
    protected Map nodeLevelMap = new Hashtable();
    protected Map oppositeInsertLinkMap = new Hashtable();
    protected Map oppositeRemoveLinkMap = new Hashtable();
    protected Collection creates = new Vector();
    protected Collection deletes = new Vector();

    static {
        try {
            MergePackageImpl.init();
            fac = (MergeFactory)MergePackage.eINSTANCE.getEFactoryInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DeltaQuery(Delta d) {
        this.delta = d;
        this.createNodeLevelSubDeltaMap(d);
        this.computeOppositeModifyLinks();
    }

    protected void createNodeLevelSubDeltaMap(Delta d) {
        Iterator it = d.getContent().iterator();
        while (it.hasNext()) {
            NodeLevelSubDelta sub = (NodeLevelSubDelta)it.next();
            this.nodeLevelMap.put(sub.getId(), sub);
            if (sub instanceof Create) {
                this.creates.add(sub);
                continue;
            }
            if (!(sub instanceof Delete)) continue;
            this.deletes.add(sub);
        }
    }

    private void computeOppositeModifyLinks() {
        Iterator it = this.delta.getContent().iterator();
        while (it.hasNext()) {
            NodeLevelSubDelta o = (NodeLevelSubDelta)it.next();
            Iterator it2 = o.getContent().iterator();
            while (it2.hasNext()) {
                Iterator it3;
                Object o2 = it2.next();
                if (!(o2 instanceof ModifyLink)) continue;
                ModifyLink ml = (ModifyLink)o2;
                if (ml.getRemove() != null) {
                    it3 = ml.getRemove().getRef().iterator();
                    while (it3.hasNext()) {
                        String id = (String)it3.next();
                        Vector<RemoveLink> removeLinks = (Vector<RemoveLink>)this.oppositeRemoveLinkMap.get(id);
                        if (removeLinks == null) {
                            removeLinks = new Vector<RemoveLink>();
                            this.oppositeRemoveLinkMap.put(id, removeLinks);
                        }
                        logger.debug((Object)("put opposite: " + id + " -> RemoveLink " + ml.getProperty() + ml.getRemove().getRef()));
                        removeLinks.add(ml.getRemove());
                    }
                }
                it3 = ml.getInsert().iterator();
                while (it3.hasNext()) {
                    InsertLink il = (InsertLink)it3.next();
                    Iterator it4 = il.getRef().iterator();
                    while (it4.hasNext()) {
                        String id = (String)it4.next();
                        Vector<InsertLink> insertLinks = (Vector<InsertLink>)this.oppositeInsertLinkMap.get(id);
                        if (insertLinks == null) {
                            insertLinks = new Vector<InsertLink>();
                            this.oppositeInsertLinkMap.put(id, insertLinks);
                        }
                        logger.debug((Object)("put opposite: " + id + " -> InsertLink " + ml.getProperty().getName() + " " + il.getRef()));
                        insertLinks.add(il);
                    }
                }
            }
        }
    }

    public Delta getDelta() {
        return this.delta;
    }

    public Collection getAllNodeLevelSubDeltas() {
        return this.nodeLevelMap.values();
    }

    public Collection getCreates() {
        return this.creates;
    }

    public Collection getDeletes() {
        return this.deletes;
    }

    public Collection getCreatedNodeIDs() {
        Vector<String> r = new Vector<String>();
        Iterator it = this.creates.iterator();
        while (it.hasNext()) {
            Create c = (Create)it.next();
            r.add(c.getId());
        }
        return r;
    }

    public Collection getDeletedNodeIDs() {
        Vector<String> r = new Vector<String>();
        Iterator it = this.deletes.iterator();
        while (it.hasNext()) {
            Create c = (Create)it.next();
            r.add(c.getId());
        }
        return r;
    }

    public Collection getDeletes(Collection ids) {
        Vector result = new Vector();
        Iterator it = ids.iterator();
        while (it.hasNext()) {
            String id = (String)it.next();
            Object o = this.nodeLevelMap.get(id);
            if (!(o instanceof Delete)) continue;
            result.add(o);
        }
        return result;
    }

    public void changeID(String oldID, String newID) {
        Object o = this.nodeLevelMap.get(oldID);
        if (!(o instanceof Create)) {
            throw new IllegalArgumentException("invalide ID " + oldID + " -> " + o);
        }
        if (this.nodeLevelMap.containsKey(newID)) {
            throw new IllegalArgumentException("invalide ID- already exist " + newID + " -> " + this.nodeLevelMap.get(newID));
        }
        Create c = (Create)o;
        this.nodeLevelMap.remove(oldID);
        this.nodeLevelMap.put(newID, c);
        c.setId(newID);
        if (this.oppositeInsertLinkMap.get(oldID) != null) {
            Collection col = (Collection)this.oppositeInsertLinkMap.get(oldID);
            this.oppositeInsertLinkMap.remove(oldID);
            this.oppositeInsertLinkMap.put(newID, col);
            Iterator it = col.iterator();
            while (it.hasNext()) {
                InsertLink link = (InsertLink)it.next();
                int i = link.getRef().indexOf((Object)oldID);
                link.getRef().remove(i);
                link.getRef().add(i, (Object)newID);
            }
        }
    }

    public ModifyPrimitive getModifyPrimitive(String ownerID, EAttribute a) {
        return (ModifyPrimitive)this.getModifyProp(ownerID, (EStructuralFeature)a);
    }

    public ModifyLink getModifyLink(String ownerID, EReference r) {
        return (ModifyLink)this.getModifyProp(ownerID, (EStructuralFeature)r);
    }

    public Collection getInsertLinks(String ownerID) {
        Vector c = new Vector();
        NodeLevelSubDelta sub = this.getNodeLevelSubDelta(ownerID);
        if (sub == null) {
            return c;
        }
        Iterator it = sub.getContent().iterator();
        while (it.hasNext()) {
            ModifyProp mp = (ModifyProp)it.next();
            if (!(mp instanceof ModifyLink)) continue;
            ModifyLink ml = (ModifyLink)mp;
            c.addAll(ml.getInsert());
        }
        return c;
    }

    public Collection getRemoveLinks(String ownerID) {
        Vector<RemoveLink> c = new Vector<RemoveLink>();
        NodeLevelSubDelta sub = this.getNodeLevelSubDelta(ownerID);
        if (sub == null) {
            return c;
        }
        Iterator it = sub.getContent().iterator();
        while (it.hasNext()) {
            ModifyProp mp = (ModifyProp)it.next();
            if (!(mp instanceof ModifyLink)) continue;
            ModifyLink ml = (ModifyLink)mp;
            c.add(ml.getRemove());
        }
        return c;
    }

    public Collection getInsertLinks(String ownerID, EReference r) {
        ModifyLink ml = this.getModifyLink(ownerID, r);
        if (ml == null) {
            return new Vector();
        }
        return ml.getInsert();
    }

    public Collection getRemoveLinks(String ownerID, EReference r) {
        ModifyLink ml = this.getModifyLink(ownerID, r);
        if (ml == null) {
            return new Vector();
        }
        if (ml.getRemove() == null) {
            return new Vector();
        }
        Vector<RemoveLink> result = new Vector<RemoveLink>();
        result.add(ml.getRemove());
        return result;
    }

    public Collection getOppositeInsertLinks(String ownerID) {
        Collection c = (Collection)this.oppositeInsertLinkMap.get(ownerID);
        if (c != null) {
            return c;
        }
        return new Vector();
    }

    public Collection getOppositeRemoveLinks(String ownerID) {
        Collection c = (Collection)this.oppositeRemoveLinkMap.get(ownerID);
        if (c != null) {
            return c;
        }
        return new Vector();
    }

    public Collection getOppositeInsertLinks(String ownerID, EReference r) {
        Collection c = this.getOppositeInsertLinks(ownerID);
        Vector<EObject> result = new Vector<EObject>();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            EObject o = (EObject)it.next();
            ModifyLink ml = (ModifyLink)o.eContainer();
            if (ml.getProperty() != r) continue;
            result.add(o);
        }
        return result;
    }

    public Collection getOppositeRemoveLinks(String ownerID, EReference r) {
        Collection c = this.getOppositeRemoveLinks(ownerID);
        Vector<EObject> result = new Vector<EObject>();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            EObject o = (EObject)it.next();
            ModifyLink ml = (ModifyLink)o.eContainer();
            if (ml.getProperty() != r) continue;
            result.add(o);
        }
        return result;
    }

    public NodeLevelSubDelta getNodeLevelSubDelta(String ownerID) {
        return (NodeLevelSubDelta)this.nodeLevelMap.get(ownerID);
    }

    private ModifyProp getModifyProp(String ownerID, EStructuralFeature f) {
        NodeLevelSubDelta sub = this.getNodeLevelSubDelta(ownerID);
        if (sub == null) {
            return null;
        }
        return DeltaQuery.getModifyProp(sub, f);
    }

    public static ModifyProp getModifyProp(NodeLevelSubDelta modify, EStructuralFeature f) {
        Iterator it = modify.getContent().iterator();
        while (it.hasNext()) {
            ModifyProp mp = (ModifyProp)it.next();
            if (!f.equals(mp.getProperty())) continue;
            return mp;
        }
        return null;
    }

    public static EReference getProperty(ModifyLinkElement e) {
        ModifyLink ml = (ModifyLink)e.eContainer();
        if (ml == null) {
            return null;
        }
        return (EReference)ml.getProperty();
    }

    public static String getOwnerID(SubDelta d) {
        SubDelta p = d;
        while (!(p instanceof NodeLevelSubDelta) && p != null) {
            p = p.eContainer();
        }
        if (p == null) {
            return null;
        }
        return ((NodeLevelSubDelta)p).getId();
    }

    public static Merge getMerge(SubDelta d) {
        EObject p = d.eContainer();
        while (p != null && !(p instanceof Merge)) {
            p = p.eContainer();
        }
        if (p == null) {
            return null;
        }
        return (Merge)p;
    }

    public static Delta getDelta(SubDelta s) {
        EObject o = s.eContainer();
        while (o != null && !(o instanceof Delta)) {
            o = o.eContainer();
        }
        return (Delta)o;
    }

    public static boolean isLocalSubDelta(SubDelta s) {
        Delta d = DeltaQuery.getDelta(s);
        if (d == null) {
            return true;
        }
        return d.isLocal();
    }
}

