/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.merge;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class MergeHelper {
    static Logger logger = Logger.getLogger((String)"MergeHelper");
    static String SEPARATOR = "<SEP>";

    public static Collection getExtraElements(Resource base, Resource resource) {
        Vector<String> result = new Vector<String>();
        TreeIterator it = resource.getAllContents();
        while (it.hasNext()) {
            EObject o = (EObject)it.next();
            String id = resource.getURIFragment(o);
            EObject o2 = base.getEObject(id);
            if (o2 != null) continue;
            result.add(id);
        }
        return result;
    }

    public static boolean areDiffrent(Object v1, Object v2) {
        if (v1 == null) {
            return v2 != null;
        }
        return !v1.equals(v2);
    }

    public static String serializeValue(EDataType type, Object value) {
        StringBuffer buf = new StringBuffer();
        if (value instanceof Collection) {
            Iterator it = ((Collection)value).iterator();
            while (it.hasNext()) {
                Object item = it.next();
                String string = EcoreUtil.convertToString((EDataType)type, item);
                buf.append(string);
                if (!it.hasNext()) continue;
                buf.append(SEPARATOR);
            }
        } else if (value != null) {
            return EcoreUtil.convertToString((EDataType)type, (Object)value);
        }
        return null;
    }

    public static Object deserializeValue(EAttribute a, String string) {
        if (string == null) {
            return null;
        }
        EDataType t = a.getEAttributeType();
        if (a.isMany()) {
            Object item;
            String sub;
            int end;
            Vector<Object> c = new Vector<Object>();
            int begin = 0;
            while ((end = string.indexOf(SEPARATOR, begin)) != -1) {
                sub = string.substring(begin, end);
                item = MergeHelper.deserializePrimitive(t, sub);
                c.add(item);
                begin = end + 2;
            }
            sub = string.substring(begin, string.length());
            item = MergeHelper.deserializePrimitive(t, sub);
            c.add(item);
            return c;
        }
        return MergeHelper.deserializePrimitive(t, string);
    }

    public static Object deserializePrimitive(EDataType type, String string) {
        return EcoreUtil.createFromString((EDataType)type, (String)string);
    }

    public static boolean doesLinkChange(EReference r, Object oldValue, Object newValue) {
        if (r.isMany()) {
            Collection oldCol = (Collection)oldValue;
            Collection newCol = (Collection)newValue;
            if (oldCol.size() != newCol.size()) {
                return true;
            }
            List ids1 = MergeHelper.getIDList(oldCol);
            List ids2 = MergeHelper.getIDList(newCol);
            if (r.isOrdered()) {
                return !ids1.equals(ids2);
            }
            HashSet s1 = new HashSet(ids1);
            return !s1.equals(ids2);
        }
        return !MergeHelper.equalsByID((EObject)oldValue, (EObject)newValue);
    }

    public static boolean needsComparison(EStructuralFeature f) {
        if (f.isDerived() || f.isTransient() || !f.isChangeable()) {
            return false;
        }
        if (f instanceof EAttribute) {
            return true;
        }
        return MergeHelper.isMainReference((EReference)f);
    }

    public static boolean isMainReference(EReference r) {
        EReference op = r.getEOpposite();
        if (op == null) {
            return true;
        }
        if (r.isContainment()) {
            return true;
        }
        if (r.isContainer()) {
            return false;
        }
        if (r.isOrdered() && r.isMany()) {
            return true;
        }
        if (op.isOrdered() && op.isMany()) {
            return false;
        }
        if (!r.isMany() && op.isMany()) {
            return false;
        }
        if (r.isMany() && !op.isMany()) {
            return true;
        }
        return MergeHelper.chooseLexicographically(r, op);
    }

    static boolean chooseLexicographically(EReference r, EReference op) {
        String owner2;
        EClass c1 = r.getEContainingClass();
        EClass c2 = op.getEContainingClass();
        String owner1 = r.getContainerClass().getName();
        int comp = owner1.compareTo(owner2 = op.getContainerClass().getName());
        if (comp < 0) {
            return true;
        }
        if (comp > 0) {
            return false;
        }
        if (c1 == c2) {
            String uri2;
            String uri1 = MergeHelper.getURI((EObject)c1);
            comp = uri1.compareTo(uri2 = MergeHelper.getURI((EObject)c2));
            if (comp < 0) {
                return true;
            }
            if (comp > 0) {
                return false;
            }
        }
        if ((comp = r.getName().compareTo(op.getName())) < 0) {
            return true;
        }
        if (comp > 0) {
            return false;
        }
        return false;
    }

    public static String getURI(EObject o) {
        Resource r = o.eResource();
        if (r == null) {
            return "null";
        }
        return String.valueOf(r.getURI().toString()) + "#" + r.getURIFragment(o);
    }

    public static boolean equalsByID(EObject o1, EObject o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        String id1 = MergeHelper.getURIFragment(o1);
        String id2 = MergeHelper.getURIFragment(o2);
        return id1.equals(id2);
    }

    public static String getURIFragment(EObject o) {
        Resource r = o.eResource();
        if (r == null) {
            return "null";
        }
        return r.getURIFragment(o);
    }

    public static List getIDList(Collection objects) {
        Vector<String> ids = new Vector<String>();
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            EObject o = (EObject)it.next();
            String id = MergeHelper.getURIFragment(o);
            ids.add(id);
        }
        return ids;
    }

    public static List getEObjectList(Resource r, List ids) {
        Vector<EObject> result = new Vector<EObject>();
        Iterator it = ids.iterator();
        while (it.hasNext()) {
            String id = (String)it.next();
            EObject o = r.getEObject(id);
            if (o != null) {
                result.add(o);
                continue;
            }
            logger.debug((Object)("id not found: " + id + " " + r));
        }
        return result;
    }

    public static EObject findObjectWithID(List objectList, String id) {
        Iterator it = objectList.iterator();
        while (it.hasNext()) {
            EObject o = (EObject)it.next();
            if (!id.equals(MergeHelper.getURIFragment(o))) continue;
            return o;
        }
        return null;
    }

    public static Collection getCommonElements(Resource base, Resource resource) {
        Vector<String> result = new Vector<String>();
        TreeIterator it = resource.getAllContents();
        while (it.hasNext()) {
            EObject o = (EObject)it.next();
            String id = resource.getURIFragment(o);
            EObject o2 = base.getEObject(id);
            if (o2 == null) continue;
            result.add(id);
        }
        return result;
    }
}

