/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.uml2;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.GlobalResourceRegistry;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelBusResourceSet;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelUtil;
import org.eclipse.uml2.Model;
import org.eclipse.uml2.Profile;
import org.eclipse.uml2.impl.UML2PackageImpl;
import org.eclipse.uml2.util.UML2Resource;

public class Uml2ModelUtil {
    static Logger logger = Logger.getLogger((String)"Uml2ModelUtil");
    public static String PREFIX_UML_PROFILE = "pathmap://ModelBus/UML2Profile/";

    static {
        UML2PackageImpl.init();
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("uml2", UML2Resource.Factory.INSTANCE);
    }

    public static void init(URI umlResourceURI) {
        Uml2ModelUtil.registerPathmaps(umlResourceURI);
    }

    static void registerPathmaps(URI umlResourceURI) {
        URIConverter.URI_MAP.put(URI.createURI((String)"pathmap://UML2_LIBRARIES/"), umlResourceURI.appendSegment("libraries").appendSegment(""));
        URIConverter.URI_MAP.put(URI.createURI((String)"pathmap://UML2_METAMODELS/"), umlResourceURI.appendSegment("metamodels").appendSegment(""));
        URIConverter.URI_MAP.put(URI.createURI((String)"pathmap://UML2_PROFILES/"), umlResourceURI.appendSegment("profiles").appendSegment(""));
    }

    public static Profile getRegisteredProfile(String profileName) {
        URI uri = Uml2ModelUtil.createProfileGlobalURI(profileName);
        Resource r = ModelBusResourceSet.getGlobalResourceRegistry().getResource(uri);
        Profile prof = (Profile)ModelUtil.findElementByName((Collection)r.getContents(), profileName);
        return prof;
    }

    public static Profile registerProfile(URI uri) throws IOException {
        ModelBusResourceSet rs = new ModelBusResourceSet();
        Resource r = rs.createResource(uri);
        r.load(null);
        Iterator it = r.getContents().iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof Profile)) continue;
            Profile prof = (Profile)o;
            Uml2ModelUtil.registerProfile(prof);
            return prof;
        }
        return null;
    }

    public static void registerProfile(Profile prof) {
        URI uri = Uml2ModelUtil.createProfileGlobalURI(prof.getName());
        Resource r = prof.eResource();
        if (r == null) {
            r = Uml2ModelUtil.createContainerResource(prof);
        }
        try {
            ModelBusResourceSet.getGlobalResourceRegistry().registerResource(uri, r);
        }
        catch (GlobalResourceRegistry.GlobalResourceException e) {
            logger.error((Object)"registerProfile", (Throwable)e);
        }
        Uml2ModelUtil.registerEcorePackagesOfProfile(prof);
    }

    public static void registerEcorePackagesOfProfile(Profile prof) {
        EAnnotation anno = null;
        Iterator it = prof.getEAnnotations().iterator();
        while (it.hasNext()) {
            anno = (EAnnotation)it.next();
            if (!"ePackages".equals(anno.getSource())) continue;
            Iterator it2 = anno.getContents().iterator();
            while (it2.hasNext()) {
                EPackage ep = (EPackage)it2.next();
                EPackage.Registry.INSTANCE.put((Object)ep.getNsURI(), (Object)ep);
            }
            return;
        }
    }

    public static void setAliasURIToProfile(URI aliasURI, Profile prof) {
        ModelBusResourceSet.getGlobalResourceRegistry().getURIConverter().getURIMap().put(aliasURI, prof.eResource().getURI());
    }

    static Resource createContainerResource(Profile prof) {
        ModelBusResourceSet rs = new ModelBusResourceSet();
        Resource r = rs.createResource(Uml2ModelUtil.createProfileGlobalURI(prof.getName()));
        r.getContents().add((Object)prof);
        return r;
    }

    static URI createProfileGlobalURI(String profileName) {
        return URI.createURI((String)(String.valueOf(PREFIX_UML_PROFILE) + profileName + ".profile.uml2"));
    }

    public static boolean hasLink(Model umlModel, Profile profile) {
        Iterator it = umlModel.getAllAppliedProfiles().iterator();
        while (it.hasNext()) {
            Profile prof1 = (Profile)it.next();
            if (!prof1.equals(profile)) continue;
            System.out.println("OK: model is linked to " + profile);
            return true;
        }
        System.out.println("Not ok: model is not linked to " + profile);
        return false;
    }
}

