/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport.client.ws;

import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import org.apache.log4j.Logger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.axisasync.AsyncConnectionManager;
import org.eclipse.mddi.modelbus.adapter.infrastructure.axisasync.NoAsyncConnectionFoundException;
import org.eclipse.mddi.modelbus.adapter.infrastructure.axisasync.ResultNotReadyException;
import org.eclipse.mddi.modelbus.adapter.infrastructure.axisasync.SOAPAsyncConnection;
import org.eclipse.mddi.modelbus.adapter.infrastructure.axisasync.ThreadPoolQueue;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.DescriptionUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.client.AbstractInvocationSender;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.marshal.ws.DefaultMarshaler;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.marshal.ws.SoapUtil;
import org.eclipse.mddi.modelbus.adapter.user.ModelingServiceError;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelBusCommunicationException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelTypeMismatchException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.NoToolAvailableException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ServiceUnknownException;
import org.eclipse.mddi.modelbus.description.abstract_.Error;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingService;
import org.eclipse.mddi.modelbus.description.abstract_.Parameter;

public class DefaultWsInvocationSender
extends AbstractInvocationSender {
    private static Logger logger;
    protected static final int DEFAULT_WORKING_THREADS_NUMBER = 20;
    protected static Map connexionId2modelingService;
    protected static ThreadPoolQueue poolQueue;
    public SOAPMessage requestMsg;
    public SOAPMessage responseMsg;
    public String targetUrl;
    public Object[] unmarshalledInputs;
    public Object[] unmarshalledOutputs;
    public ModelingService ms;
    public String connectionId;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.mddi.modelbus.adapter.infrastructure.transport.client.ws.DefaultWsInvocationSender");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
        connexionId2modelingService = new Hashtable();
        poolQueue = null;
    }

    public DefaultWsInvocationSender(Properties prop) {
        if (this.getMarshaler() == null) {
            this.setMarshaler(new DefaultMarshaler(prop));
        }
    }

    public Object[] invoke(ModelingService ms, Object[] inputs) throws ServiceUnknownException, NoToolAvailableException, ModelTypeMismatchException, ModelBusCommunicationException, ModelingServiceError {
        this.targetUrl = DescriptionUtil.getProperty(this.getToolDescription(), "URL");
        this.ms = ms;
        this.unmarshalledInputs = inputs;
        try {
            this.responseMsg = SoapUtil.messageFactory.createMessage();
            this.createRequestMessage();
            this.makeConnection();
            this.readResponseMessage();
            return this.unmarshalledOutputs;
        }
        catch (SOAPException e) {
            e.printStackTrace();
            throw new ModelBusCommunicationException("targetUrl=" + this.targetUrl + " " + e.getMessage(), e);
        }
    }

    public void createRequestMessage() throws ModelBusCommunicationException, ModelTypeMismatchException {
        if (this.requestMsg == null) {
            try {
                this.requestMsg = SoapUtil.messageFactory.createMessage();
                SOAPBody requestbody = this.requestMsg.getSOAPBody();
                DefaultMarshaler.setNamespaces(requestbody);
                SOAPElement reqTopElem = requestbody.addChildElement(this.ms.getName(), "modelbus");
                List inputParams = DescriptionUtil.get_in_inout_Parameters(this.ms);
                Parameter[] params = inputParams.toArray(new Parameter[inputParams.size()]);
                this.getMarshaler().marshal(params, this.unmarshalledInputs, reqTopElem);
            }
            catch (Exception e) {
                throw new ModelBusCommunicationException("Can't create request message", e);
            }
        }
    }

    public void makeConnection() throws SOAPException {
        logger.debug((Object)("Call URL: " + this.targetUrl));
        SOAPConnection con = SoapUtil.connectionFactory.createConnection();
        logger.debug((Object)("Call with Message: " + this.requestMsg.getSOAPBody().toString()));
        this.responseMsg = con.call(this.requestMsg, (Object)this.targetUrl);
        con.close();
        logger.debug((Object)("Response Message: " + this.responseMsg.getSOAPBody().toString()));
    }

    public void readResponseMessage() throws ModelBusCommunicationException, ModelingServiceError {
        SOAPBody responsebody = null;
        try {
            responsebody = this.responseMsg.getSOAPBody();
        }
        catch (SOAPException e1) {
            throw new ModelBusCommunicationException("Can't parse response message", e1);
        }
        if (responsebody.hasFault()) {
            SOAPFault f = responsebody.getFault();
            if (DefaultMarshaler.isModelingServiceError(f)) {
                String errorName = DefaultMarshaler.getModelingServiceErrorName(f);
                Error errorType = null;
                if (errorName != null) {
                    errorType = DescriptionUtil.getError(this.ms, errorName);
                }
                ModelingServiceError err = null;
                try {
                    err = this.getMarshaler().unmarshalModelingServiceError(errorType, f);
                }
                catch (SOAPException e) {
                    logger.error((Object)"Can't unmarshal ModelingServiceError", (Throwable)e);
                }
                throw err;
            }
            throw new ModelBusCommunicationException(String.valueOf(f.toString()) + "[ uri = " + this.targetUrl + "]");
        }
        SOAPElement resTopElem = SoapUtil.getFirstChild((SOAPElement)responsebody);
        if (resTopElem == null) {
            logger.error((Object)"Empty SOAP response");
            logger.debug((Object)responsebody.toString());
            throw new ModelBusCommunicationException("Empty SOAP response");
        }
        List outputParams = DescriptionUtil.get_out_inout_Parameters(this.ms);
        Parameter[] params = new Parameter[outputParams.size()];
        int i = 0;
        while (i < outputParams.size()) {
            params[i] = (Parameter)outputParams.get(i);
            ++i;
        }
        try {
            this.unmarshalledOutputs = this.getMarshaler().unmarshal(params, resTopElem);
        }
        catch (Exception e) {
            throw new ModelBusCommunicationException("Can't unmarshal response message", e);
        }
    }

    public String invokeAsync(ModelingService ms, Object[] inputs) throws ServiceUnknownException, NoToolAvailableException, ModelTypeMismatchException, ModelBusCommunicationException, ModelingServiceError {
        String targetUrl = DescriptionUtil.getProperty(this.getToolDescription(), "URL");
        this.ms = ms;
        this.unmarshalledInputs = inputs;
        this.targetUrl = DescriptionUtil.getProperty(this.getToolDescription(), "URL");
        try {
            if (poolQueue == null) {
                DefaultWsInvocationSender.createThreadPoolQueue();
            }
            this.responseMsg = SoapUtil.messageFactory.createMessage();
            this.createRequestMessage();
            this.makeAsyncConnection();
            return this.connectionId;
        }
        catch (SOAPException e) {
            throw new ModelBusCommunicationException("targetUrl=" + targetUrl + " " + e.getMessage(), e);
        }
    }

    public void makeAsyncConnection() throws SOAPException {
        SOAPAsyncConnection con = SoapUtil.asyncConnectionFactory.createAsyncConnection();
        this.connectionId = con.call(this.requestMsg, this.targetUrl, poolQueue);
        AsyncConnectionManager.getInstance().putAsyncConnection(this.connectionId, con);
        connexionId2modelingService.put(this.connectionId, this.ms);
    }

    public void closeAsyncConnection(String connexionId) throws SOAPException, NoAsyncConnectionFoundException {
        SOAPAsyncConnection con = AsyncConnectionManager.getInstance().getAsyncConnection(connexionId);
        con.close();
        AsyncConnectionManager.getInstance().removeAsyncConnection(String.valueOf(con.hashCode()));
        connexionId2modelingService.remove(connexionId);
    }

    public boolean isResultReady(String connexionId) throws ServiceUnknownException, NoToolAvailableException, ModelTypeMismatchException, ModelBusCommunicationException, NoAsyncConnectionFoundException, ModelingServiceError {
        boolean resultReady = false;
        try {
            SOAPAsyncConnection con = AsyncConnectionManager.getInstance().getAsyncConnection(connexionId);
            resultReady = con.isResultReady();
        }
        catch (NoAsyncConnectionFoundException e) {
            e.printStackTrace();
        }
        return resultReady;
    }

    public Object[] getResult(String connexionId) throws ResultNotReadyException, NoAsyncConnectionFoundException, ServiceUnknownException, NoToolAvailableException, ModelTypeMismatchException, ModelBusCommunicationException, ModelingServiceError {
        try {
            SOAPAsyncConnection con = AsyncConnectionManager.getInstance().getAsyncConnection(connexionId);
            this.responseMsg = (SOAPMessage)con.getResult();
            ModelingService ms = (ModelingService)connexionId2modelingService.get(connexionId);
            if (ms == null) {
                throw new Exception("ModelingService not avaible");
            }
            this.readResponseMessage();
            this.closeAsyncConnection(connexionId);
            if (poolQueue.isEmpty()) {
                DefaultWsInvocationSender.closeThreadPoolQueue();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.unmarshalledOutputs;
    }

    public static void closeThreadPoolQueue() {
        poolQueue.close();
        poolQueue = null;
    }

    public static void createThreadPoolQueue() {
        poolQueue = new ThreadPoolQueue(20);
    }
}

