/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * Created on 5 juil. 2005
 *
 */
package org.eclipse.mddi.modelbus.adapter.test.unit;

import java.io.IOException;
import java.util.Collection;

import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.DescriptionUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.GlobalResourceRegistry;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.registry.DefaultToolSelector;
import org.eclipse.mddi.modelbus.adapter.infrastructure.registry.RegistryClient;
import org.eclipse.mddi.modelbus.adapter.infrastructure.registry.RegistryManager;
import org.eclipse.mddi.modelbus.adapter.infrastructure.registry.RegistryNotAvailableException;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.emf_xmi.Xmi2EmfConversion;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.ServerManager;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.axis.SimpleModelBusServer;
import org.eclipse.mddi.modelbus.adapter.test.registry.BasicRegistry;
import org.eclipse.mddi.modelbus.description.concrete.Tool;


import junit.framework.TestCase;

/**
 * Check that Adapter can communicate with Registry
 * 
 * @author P. Sriplakich
 *
 */
public class RegistryTest extends TestCase {
    
    public static void main(String[] args) {
        junit.textui.TestRunner.run(RegistryTest.class);
    }
    
    String url = BasicRegistry.getUrl();
    RegistryClient client;
    
    
    /*
     * @see TestCase#setUp()
     */
    protected void setUp() throws Exception {
        try {
            //start the registry
            // TODO. replace with Registry of FGH
            BasicRegistry.main(null);
            
            
            client = RegistryManager.getInstance()
            	.getRegistryClient(url);
            
            
        } catch(Exception e) {
            throw new Exception("TestCase can not be initialized", e);
        }
    }

    /*
     * @see TestCase#tearDown()
     */
    protected void tearDown() throws Exception {
//        BasicRegistry.stop();

    }        
    
    
    /**
     * Check that the Adapter can register a tool
     */
    public void testRegisterTool() throws RegistryNotAvailableException {
        Tool t = Util.createToolDescription();
        client.registerTool(t);
    }
    

    
    /**
     * Once register, the tool must be found
     */    
    public void testLookupServices_foundByNonQualifiedServiceName() throws Exception {
        
        //make sure tool is registered
        testRegisterTool();
        //make sure server is running, thus Tool host is accessible
        SimpleModelBusServer s= new SimpleModelBusServer(ServerManager.DEFAULT_MB_PORT);
        //
        
        Tool t = client.lookupToolByModelingService("service1", new DefaultToolSelector());
        System.out.println("Tool found:"+t);
        assertNotNull(t);
    }

    
    public void testLookupServices_foundByNonQualifiedServiceNameWithInterfaceName() throws Exception {
        //make sure tool is registered
        testRegisterTool();
        //make sure server is running, thus Tool host is accessible
        SimpleModelBusServer s= new SimpleModelBusServer(ServerManager.DEFAULT_MB_PORT);
        //
        
        Tool t = client.lookupToolByModelingService("ModelingServiceInterface1.service1", new DefaultToolSelector());
        System.out.println("Tool found:"+t);
        assertNotNull(t);
    }

    
    public void testLookupServices_foundByQualifiedServiceName() throws Exception {
        //make sure tool is registered
        testRegisterTool();
        //make sure server is running, thus Tool host is accessible
        SimpleModelBusServer s= new SimpleModelBusServer(ServerManager.DEFAULT_MB_PORT);
        //
        
        Tool t = client.lookupToolByModelingService("Tool1.ModelingServiceInterface1.service1", new DefaultToolSelector());
        System.out.println("Tool found:"+t);
        assertNotNull(t);
    }

    /**
     * If a no tool provides the specified service, lookup returns null.
     */    
    public void testLookupServices_notFound() throws RegistryNotAvailableException {
        Tool t = client.lookupToolByModelingService("service2", new DefaultToolSelector());
        assertNull(t);
    }
    
    /**
     * Check that the Adapter can register a real tool
     * @throws IOException
     */
    public void testRegisterComplexTool() throws RegistryNotAvailableException, IOException {
        String path = "./src/org/eclipse/mddi/modelbus/adapter/test/sample/sample.description";
        
        Collection emfobjs = Xmi2EmfConversion.convertFromFile(path, false);
        Collection col = ModelUtil.findElementByType(emfobjs, "Tool");
        Tool t = (Tool)col.iterator().next();
        DescriptionUtil.importAllMetamodels(t, GlobalResourceRegistry.GLOBAL_URI_PREFIX_SET);
        
        client.registerTool(t);
    }

    
    /**
     * Check that the Adapter can lookup a real tool
     * @throws IOException
     */
    
    public void testLookupServices_foundComplex() throws Exception {
        //make sure tool is registered
        testRegisterComplexTool();
        //make sure server is running, thus Tool host is accessible
        SimpleModelBusServer s= new SimpleModelBusServer(ServerManager.DEFAULT_MB_PORT);
        //
        
        Tool t = client.lookupToolByModelingService("interface1.createNewClass", new DefaultToolSelector());
        System.out.println("Tool found:"+t);
        assertNotNull(t);
    }


    

}
