/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.logging.Level;
import org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger;

public class IndentStream {
    boolean enableLog = true;
    boolean enableConsole = true;
    int initialIndent = 0;
    String prefix = "";
    PrintStream consoleDestination = null;

    public IndentStream(String prefix, OutputStream console) {
        this.prefix = prefix;
        this.setConsoleDestination(console);
    }

    public void println(String message) {
        this.println(0, message);
    }

    public void println(int indentLevel, String message) {
        int i;
        StringBuffer indentString = new StringBuffer("");
        if (this.enableLog) {
            i = 0;
            while (i < indentLevel) {
                indentString.append("   ");
                ++i;
            }
            RootLogger.getLogger().log(Level.INFO, indentString + message);
        }
        if (this.enableConsole && this.consoleDestination != null) {
            i = 0;
            while (i < this.initialIndent) {
                indentString.append("   ");
                ++i;
            }
            this.consoleDestination.println(indentString + this.prefix + message);
        }
    }

    public PrintStream getConsoleDestination() {
        return this.consoleDestination;
    }

    public void setConsoleDestination(OutputStream console) {
        if (console instanceof PrintStream) {
            this.consoleDestination = (PrintStream)console;
        } else if (console != null) {
            this.consoleDestination = new PrintStream(console);
        }
    }

    public void setInitialIndent(int indent) {
        this.initialIndent = indent;
    }

    public int getInitialIndent() {
        return this.initialIndent;
    }

    public boolean isEnableConsole() {
        return this.enableConsole;
    }

    public void setEnableConsole(boolean enableConsole) {
        this.enableConsole = enableConsole;
    }

    public boolean isEnableLog() {
        return this.enableLog;
    }

    public void setEnableLog(boolean enableLog) {
        this.enableLog = enableLog;
    }
}

