/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.mb_xmi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import java.util.logging.Level;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.mb_xmi.IdTableRegistry;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.mb_xmi.MBModelDeserializer;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.mb_xmi.MBModelSerializer;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.mb_xmi.RestoreManager;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.DefaultModelSerializer;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.DeserializedModel;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.SerializedXmiDocument;
import org.xml.sax.SAXException;

public class IdModelSerializer
extends DefaultModelSerializer {
    public IdModelSerializer() {
        this.setSkipCrossReferences(true);
    }

    protected void saveResource(Resource r, OutputStream out) throws IOException {
        MBModelSerializer ser = new MBModelSerializer();
        ser.serializeResource(r, out);
    }

    protected void loadResource(Resource r, InputStream in) throws IOException {
        MBModelDeserializer deser = new MBModelDeserializer(r);
        try {
            deser.deserialize(in);
        }
        catch (SAXException e) {
            throw new IOException(e.toString());
        }
    }

    public DeserializedModel[] deserialize(SerializedXmiDocument[] documents) {
        DeserializedModel[] result = super.deserialize(documents);
        if (this.inoutResourceSet != null) {
            RestoreManager rm = new RestoreManager();
            for (Resource newResource : new Vector(this.inoutResourceSet.getResources())) {
                URI uri = newResource.getURI();
                Resource r = ModelUtil.findResourceWithURI(uri.toString(), this.sentResources);
                if (r == null) {
                    ModelUtil.findResourceWithURI(uri.toString(), this.defaultReceivedResourceSet);
                }
                if (r != null) {
                    rm.update(r, newResource);
                    continue;
                }
                RootLogger.getLogger().log(Level.WARNING, "resource not found for restoration " + uri);
            }
        }
        return result;
    }

    protected String getReference(EObject o) {
        return IdTableRegistry.getId(o);
    }

    protected EObject dereference(Resource r, String fragment) {
        if (r.getResourceSet() == this.inoutResourceSet) {
            Resource r2 = this.defaultReceivedResourceSet.getResource(r.getURI(), false);
            IdTableRegistry.getIdTable(r2).getModelElement(fragment);
        }
        return IdTableRegistry.getIdTable(r).getModelElement(fragment);
    }
}

