/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.mb_xmi;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.logging.Level;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.UUIDGenerator;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.mb_xmi.IdGenerator;

public class IdTable {
    IdGenerator idGenerator = new UUIDGenerator();
    private Map obj_id = new WeakHashMap();
    private Map id_ref = new WeakHashMap();

    public String getId(EObject o) {
        return (String)this.obj_id.get(o);
    }

    public String getOrCreateId(EObject o) {
        if (!this.obj_id.containsKey(o)) {
            String id = this.idGenerator.generateId(o, this.id_ref.keySet());
            this.assignId(id, o);
            return id;
        }
        return (String)this.obj_id.get(o);
    }

    public void assignId(String id, EObject o) {
        if (o.eIsProxy()) {
            throw new RuntimeException("Cannot assign ID to a proxy");
        }
        this.obj_id.put(o, id);
        this.id_ref.put(id, new WeakReference<EObject>(o));
    }

    public String changeId(String oldID, Collection idSet) {
        EObject o = this.getModelElement(oldID);
        if (o == null) {
            return null;
        }
        String newID = this.idGenerator.generateId(o, this.id_ref.keySet(), idSet);
        this.assignId(newID, o);
        return newID;
    }

    public void addAll(Collection modelElements) {
        Iterator it = modelElements.iterator();
        while (it.hasNext()) {
            this.getOrCreateId((EObject)it.next());
        }
    }

    public void clear() {
        this.id_ref.clear();
        this.obj_id.clear();
    }

    public EObject getModelElement(String id) {
        Reference r = (Reference)this.id_ref.get(id);
        if (r == null) {
            return null;
        }
        if (r.get() == null) {
            RootLogger.getLogger().log(Level.SEVERE, "object " + id + " has been garbage collected");
            return null;
        }
        return (EObject)r.get();
    }

    public Collection getIdSet() {
        return this.id_ref.keySet();
    }

    public Collection getModel() {
        return this.obj_id.keySet();
    }

    public List getIdsFromFragment(Collection fragment) {
        Vector<String> r = new Vector<String>();
        for (EObject o : fragment) {
            String id = this.getId(o);
            if (id != null) {
                r.add(id);
                continue;
            }
            RootLogger.getLogger().log(Level.SEVERE, "No id for " + o);
        }
        return r;
    }

    public List getFragmentFromIds(Collection ids) {
        Vector<EObject> r = new Vector<EObject>();
        for (String id : ids) {
            EObject o = this.getModelElement(id);
            if (o != null) {
                r.add(o);
                continue;
            }
            RootLogger.getLogger().log(Level.SEVERE, "No object for id " + id);
        }
        return r;
    }
}

