/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.mb_xmi;

import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.mb_xmi.IdTable;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.mb_xmi.IdTableRegistry;

public class RestoreManager {
    IdTable originalModelIdTable;
    List<EObject> originalElems = new Vector<EObject>();
    IdTable receivedModelIdTable;
    List<EObject> receivedElems = new Vector<EObject>();

    public void update(Resource orgResource, Resource newResource) {
        this.originalModelIdTable = IdTableRegistry.getIdTable(orgResource);
        this.receivedModelIdTable = IdTableRegistry.getIdTable(newResource);
        TreeIterator it = orgResource.getAllContents();
        while (it.hasNext()) {
            this.originalElems.add((EObject)it.next());
        }
        it = newResource.getAllContents();
        while (it.hasNext()) {
            this.receivedElems.add((EObject)it.next());
        }
        List originalModelIds = this.originalModelIdTable.getIdsFromFragment(this.originalElems);
        List resultFragmentIds = this.receivedModelIdTable.getIdsFromFragment(this.receivedElems);
        HashSet createdElementIds = new HashSet(resultFragmentIds);
        createdElementIds.removeAll(originalModelIds);
        HashSet commonIds = new HashSet(originalModelIds);
        commonIds.retainAll(resultFragmentIds);
        Vector<EObject> newElems = new Vector<EObject>();
        for (String id : createdElementIds) {
            EObject updatedElem = this.receivedModelIdTable.getModelElement(id);
            EClass c = updatedElem.eClass();
            EObject newElem = EcoreUtil.create((EClass)c);
            this.originalModelIdTable.assignId(id, newElem);
            newElems.add(newElem);
        }
        for (String id : resultFragmentIds) {
            EObject originalElem = this.originalModelIdTable.getModelElement(id);
            EObject updatedElem = this.receivedModelIdTable.getModelElement(id);
            this.copyElement(originalElem, updatedElem);
        }
        for (EObject o : newElems) {
            if (o.eResource() != null) continue;
            orgResource.getContents().add((Object)o);
        }
    }

    private void copyElement(EObject originalElem, EObject updatedElem) {
        for (EAttribute a : originalElem.eClass().getEAllAttributes()) {
            if (!a.isChangeable() || a.isDerived()) continue;
            Object updatedValue = updatedElem.eGet((EStructuralFeature)a);
            originalElem.eSet((EStructuralFeature)a, updatedValue);
        }
        for (EReference r : updatedElem.eClass().getEAllReferences()) {
            if (!r.isChangeable() || r.isDerived()) continue;
            if (r.isMany()) {
                List orgLinkList = (List)originalElem.eGet((EStructuralFeature)r);
                List newLinkList = (List)updatedElem.eGet((EStructuralFeature)r);
                orgLinkList.clear();
                int i = 0;
                while (i < newLinkList.size()) {
                    EObject org = this.getMatchOrgElement((EObject)newLinkList.get(i));
                    orgLinkList.add(org);
                    ++i;
                }
                continue;
            }
            EObject newLink = (EObject)updatedElem.eGet((EStructuralFeature)r);
            if (newLink != null) {
                EObject o = this.getMatchOrgElement(newLink);
                if (o == null) continue;
                originalElem.eSet((EStructuralFeature)r, (Object)o);
                continue;
            }
            if (!r.isUnsettable()) continue;
            originalElem.eUnset((EStructuralFeature)r);
        }
    }

    EObject getMatchOrgElement(EObject newElem) {
        InternalEObject org = null;
        if (newElem.eIsProxy()) {
            return newElem;
        }
        String id = this.receivedModelIdTable.getId(newElem);
        if (id != null && (org = (InternalEObject)this.originalModelIdTable.getModelElement(id)) != null) {
            return org;
        }
        URI uri = newElem.eResource().getURI();
        uri = uri.appendFragment(newElem.eResource().getURIFragment(newElem));
        org = (InternalEObject)EcoreUtil.create((EClass)newElem.eClass());
        org.eSetProxyURI(uri);
        RootLogger.getLogger().log(Level.INFO, "Proxy created " + uri);
        return org;
    }
}

