/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.Repository;
import org.eclipse.mddi.modelbus.adapter.user.consumer.GenericConsumer;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelBusCommunicationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryClient
implements Repository {
    GenericConsumer consumer;

    static URL getRepositoryUrl(String modelUri) throws ModelBusCommunicationException {
        URI uri = URI.createURI((String)modelUri);
        try {
            URL url = new URL(uri.trimFragment().toString());
            return url;
        }
        catch (MalformedURLException e) {
            throw new ModelBusCommunicationException(e);
        }
    }

    public RepositoryClient(GenericConsumer c) {
        this.consumer = c;
    }

    @Override
    public List<EObject> getModel(String uri) throws ModelBusCommunicationException {
        Hashtable<String, Object> input = new Hashtable<String, Object>();
        input.put("uri", uri);
        URL repositoryUrl = RepositoryClient.getRepositoryUrl(uri);
        Map output = this.consumer.consume(repositoryUrl, "modelbus_repository.getModel", input);
        return (List)output.get("model");
    }

    @Override
    public void putModel(String uri, List<EObject> model) throws ModelBusCommunicationException {
        Hashtable<String, Object> input = new Hashtable<String, Object>();
        input.put("uri", uri);
        URL repositoryUrl = RepositoryClient.getRepositoryUrl(uri);
        this.consumer.consume(repositoryUrl, "modelbus_repository.putModel", input);
    }
}

