/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws;

import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.DescriptionUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.AbstractInvocationSender;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.DefaultMarshaler;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.SoapUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.async.AsyncConnectionManager;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.async.NoAsyncConnectionFoundException;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.async.SOAPAsyncConnection;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.async.SOAPAsyncConnectionFactory;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.async.ThreadPoolQueue;
import org.eclipse.mddi.modelbus.adapter.user.ModelingServiceError;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelBusCommunicationException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelTypeMismatchException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.NoToolAvailableException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ServiceUnknownException;
import org.eclipse.mddi.modelbus.description.abstract_.Error;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingService;
import org.eclipse.mddi.modelbus.description.abstract_.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWsInvocationSender
extends AbstractInvocationSender {
    protected static final int DEFAULT_WORKING_THREADS_NUMBER = 20;
    protected static Map connexionId2modelingService = new Hashtable();
    protected static ThreadPoolQueue poolQueue = null;
    public SOAPMessage requestMsg;
    public SOAPMessage responseMsg;
    public Map inputs;
    public Map outputs;
    public ModelingService ms;
    public String connectionId;

    public DefaultWsInvocationSender() {
        if (this.getMarshaler() == null) {
            this.setMarshaler(new DefaultMarshaler());
        }
    }

    @Override
    public Map<String, Object> invoke(ModelingService ms, Map<String, Object> inputs) throws ModelBusCommunicationException {
        this.ms = ms;
        this.inputs = inputs;
        try {
            this.createRequestMessage();
            this.makeConnection();
            this.readResponseMessage();
            return this.outputs;
        }
        catch (SOAPException e) {
            throw new ModelBusCommunicationException(e);
        }
    }

    public void createRequestMessage() throws SOAPException, ModelBusCommunicationException {
        this.requestMsg = SoapUtil.messageFactory.createMessage();
        SOAPBody requestbody = this.requestMsg.getSOAPBody();
        DefaultMarshaler.setNamespaces(requestbody);
        SOAPElement reqTopElem = requestbody.addChildElement(this.ms.getName(), "modelbus");
        List<Parameter> params = DescriptionUtil.get_in_inout_Parameters(this.ms);
        this.getMarshaler().marshal(params, this.inputs, reqTopElem);
    }

    public void makeConnection() throws SOAPException {
        RootLogger.getLogger().log(Level.INFO, "Call URL: " + this.getToolUrl());
        SOAPConnection con = SoapUtil.connectionFactory.createConnection();
        RootLogger.getLogger().log(Level.INFO, "Request Message: \n" + DefaultWsInvocationSender.formatMessage(this.requestMsg.getSOAPBody().toString()));
        this.responseMsg = con.call(this.requestMsg, (Object)this.getToolUrl().toString());
        con.close();
        RootLogger.getLogger().log(Level.INFO, "Response Message: \n" + DefaultWsInvocationSender.formatMessage(this.responseMsg.getSOAPBody().toString()));
    }

    public static String formatMessage(String msg) {
        msg = msg.replace("&lt;", "<");
        msg = msg.replace("&quot;", "\"");
        msg = msg.replace("&gt;", ">");
        return msg;
    }

    public void readResponseMessage() throws ModelBusCommunicationException, ModelingServiceError {
        SOAPBody responsebody = null;
        try {
            responsebody = this.responseMsg.getSOAPBody();
        }
        catch (SOAPException e1) {
            throw new ModelBusCommunicationException("Can't parse response message", e1);
        }
        if (responsebody.hasFault()) {
            SOAPFault f = responsebody.getFault();
            if (DefaultMarshaler.isModelingServiceError(f)) {
                String errorName = DefaultMarshaler.getModelingServiceErrorName(f);
                Error errorType = null;
                if (errorName != null) {
                    errorType = DescriptionUtil.getError(this.ms, errorName);
                }
                ModelingServiceError err = null;
                try {
                    err = this.getMarshaler().unmarshalModelingServiceError(errorType, f);
                }
                catch (SOAPException e) {
                    RootLogger.getLogger().log(Level.SEVERE, "Can't unmarshal ModelingServiceError", e);
                }
                throw err;
            }
            throw new ModelBusCommunicationException(String.valueOf(f.toString()) + "[ uri = " + this.getToolUrl() + "]");
        }
        SOAPElement resTopElem = SoapUtil.getFirstChild((SOAPElement)responsebody);
        if (resTopElem == null) {
            RootLogger.getLogger().log(Level.SEVERE, "Empty SOAP response");
            RootLogger.getLogger().log(Level.INFO, responsebody.toString());
            throw new ModelBusCommunicationException("Empty SOAP response");
        }
        List<Parameter> params = this.getResponseParameters();
        try {
            this.outputs = this.getMarshaler().unmarshal(params, resTopElem);
        }
        catch (Exception e) {
            RootLogger.getLogger().log(Level.WARNING, "Cannot unmarshal response message", e);
            throw new ModelBusCommunicationException("Cannot unmarshal response message", e);
        }
    }

    protected List<Parameter> getResponseParameters() {
        return DescriptionUtil.get_out_inout_Parameters(this.ms);
    }

    public String invokeAsync(ModelingService ms, Map inputs) throws ModelBusCommunicationException {
        this.ms = ms;
        this.inputs = inputs;
        if (poolQueue == null) {
            DefaultWsInvocationSender.createThreadPoolQueue();
        }
        try {
            this.responseMsg = SoapUtil.messageFactory.createMessage();
            this.createRequestMessage();
            this.makeAsyncConnection();
            return this.connectionId;
        }
        catch (SOAPException e) {
            throw new ModelBusCommunicationException(e);
        }
    }

    public void makeAsyncConnection() throws SOAPException {
        SOAPAsyncConnection con = SOAPAsyncConnectionFactory.instance.createAsyncConnection();
        this.connectionId = con.call(this.requestMsg, this.getToolUrl().toString(), poolQueue);
        AsyncConnectionManager.getInstance().putAsyncConnection(this.connectionId, con);
        connexionId2modelingService.put(this.connectionId, this.ms);
    }

    public void closeAsyncConnection(String connexionId) throws SOAPException, NoAsyncConnectionFoundException {
        SOAPAsyncConnection con = AsyncConnectionManager.getInstance().getAsyncConnection(connexionId);
        con.close();
        AsyncConnectionManager.getInstance().removeAsyncConnection(String.valueOf(con.hashCode()));
        connexionId2modelingService.remove(connexionId);
    }

    @Override
    public boolean isResultReady(String connexionId) throws ServiceUnknownException, NoToolAvailableException, ModelTypeMismatchException, ModelBusCommunicationException, NoAsyncConnectionFoundException, ModelingServiceError {
        boolean resultReady = false;
        try {
            SOAPAsyncConnection con = AsyncConnectionManager.getInstance().getAsyncConnection(connexionId);
            resultReady = con.isResultReady();
        }
        catch (NoAsyncConnectionFoundException e) {
            e.printStackTrace();
        }
        return resultReady;
    }

    @Override
    public Object[] getResult(String connexionId) throws SOAPException, ModelBusCommunicationException {
        SOAPAsyncConnection con = AsyncConnectionManager.getInstance().getAsyncConnection(connexionId);
        this.responseMsg = (SOAPMessage)con.getResult();
        ModelingService ms = (ModelingService)connexionId2modelingService.get(connexionId);
        if (ms == null) {
            throw new ServiceUnknownException();
        }
        this.readResponseMessage();
        try {
            this.closeAsyncConnection(connexionId);
        }
        catch (SOAPException e) {
            throw new ModelBusCommunicationException(e);
        }
        catch (NoAsyncConnectionFoundException e) {
            throw new ModelBusCommunicationException(e);
        }
        if (poolQueue.isEmpty()) {
            DefaultWsInvocationSender.closeThreadPoolQueue();
        }
        Parameter[] outputParams = DescriptionUtil.get_out_inout_Parameters(ms).toArray(new Parameter[0]);
        Object[] result = DescriptionUtil.map2Array(outputParams, this.outputs);
        return result;
    }

    public static void closeThreadPoolQueue() {
        poolQueue.close();
        poolQueue = null;
    }

    public static void createThreadPoolQueue() {
        poolQueue = new ThreadPoolQueue(20);
    }
}

