/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import org.apache.axis.Message;
import org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.AbstractServer;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.DefaultWsInvocationReceiver;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.EndPointManager;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.ServerManager;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.SoapUtil;

public abstract class ModelBusServlet
extends HttpServlet
implements AbstractServer {
    private static final long serialVersionUID = 6796675107296804862L;
    private String context;
    EndPointManager endPointManager;

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        RootLogger.getLogger().log(Level.INFO, "Processing request");
        RootLogger.getLogger().log(Level.INFO, req.toString());
        res.setContentType("text/xml");
        try {
            String urlPath = req.getRequestURI();
            RootLogger.getLogger().log(Level.INFO, "path = " + urlPath);
            String relativePath = "";
            String begin = "/" + this.context + "/";
            if (urlPath.startsWith(begin)) {
                relativePath = urlPath.replaceFirst(begin, "");
            }
            RootLogger.getLogger().log(Level.INFO, "relative path = " + relativePath);
            Message reqMsg = (Message)SoapUtil.messageFactory.createMessage(null, (InputStream)req.getInputStream());
            Message respMsg = (Message)SoapUtil.messageFactory.createMessage();
            try {
                org.apache.axis.message.SOAPEnvelope reqEnv = reqMsg.getSOAPEnvelope();
                this.endPointManager.execute(relativePath, (SOAPEnvelope)reqEnv, (SOAPEnvelope)respMsg.getSOAPEnvelope());
            }
            catch (Exception e) {
                DefaultWsInvocationReceiver.createSimpleSoapFault((SOAPEnvelope)respMsg.getSOAPEnvelope(), e);
            }
            ServletOutputStream out = res.getOutputStream();
            respMsg.writeTo((OutputStream)out);
        }
        catch (SOAPException e) {
            RootLogger.getLogger().log(Level.SEVERE, "", e);
            throw new ServletException((Throwable)e);
        }
    }

    public void init(ServletConfig config) {
        RootLogger.getLogger().log(Level.INFO, "Init ModelBus");
        RootLogger.getLogger().log(Level.INFO, "Deploy Evry Tool");
    }

    public void setDefaultPort(int port) {
        ServerManager.DEFAULT_MB_PORT = port;
        RootLogger.getLogger().log(Level.INFO, "Setting port:" + port);
    }

    public void setDefaultContext(String context) {
        this.context = context;
        RootLogger.getLogger().log(Level.INFO, "Setting cotext:" + context);
    }

    public void registerServer() {
        ServerManager.getInstance().putServer(this);
    }

    public void setEndPointManager(EndPointManager endPointManager) {
        this.endPointManager = endPointManager;
    }

    public String getContext() {
        return this.context;
    }

    public int getPort() {
        return ServerManager.DEFAULT_MB_PORT;
    }

    protected void doPost(HttpServletRequest arg0, HttpServletResponse arg1) throws ServletException, IOException {
        this.doGet(arg0, arg1);
    }
}

