/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.async;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.async.NoAsyncConnectionFoundException;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.async.SOAPAsyncConnection;

public class AsyncConnectionManager {
    private static AsyncConnectionManager instance = new AsyncConnectionManager();
    private Map asyncConnectionMap = new Hashtable();

    public static AsyncConnectionManager getInstance() {
        return instance;
    }

    private AsyncConnectionManager() {
    }

    public void putAsyncConnection(String id, SOAPAsyncConnection con) {
        this.asyncConnectionMap.put(id, con);
    }

    public void removeAsyncConnection(String id) {
        this.asyncConnectionMap.remove(id);
    }

    public SOAPAsyncConnection getAsyncConnection(String id) throws NoAsyncConnectionFoundException {
        Object obj = this.asyncConnectionMap.get(id);
        if (obj != null && obj instanceof SOAPAsyncConnection) {
            return (SOAPAsyncConnection)obj;
        }
        throw new NoAsyncConnectionFoundException(String.valueOf(id) + " not found in AsyncConnectionManager");
    }
}

