/**
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.  All rights reserved.This software is published under the terms of the ModelBus Software License in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. A copy of ModelBus Software License is provided with this distribution in doc/LICENSE.txt file.
 *
 * $Id: ModelBusPackagingItemProvider.java,v 1.5 2007/11/01 11:12:13 tritter Exp $
 */
package org.eclipse.mddi.modelbus.description.provider;


import java.util.Collection;
import java.util.List;

import modelbus.description.provider.ModelbusEditPlugin;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.common.util.ResourceLocator;

import org.eclipse.emf.ecore.EStructuralFeature;

import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;

import org.eclipse.mddi.modelbus.description.DescriptionFactory;
import org.eclipse.mddi.modelbus.description.DescriptionPackage;
import org.eclipse.mddi.modelbus.description.ModelBusPackaging;

import org.eclipse.mddi.modelbus.description.abstract_.AbstractFactory;

import org.eclipse.mddi.modelbus.description.concrete.ConcreteFactory;

import org.eclipse.mddi.modelbus.description.datatype.DatatypeFactory;

/**
 * This is the item provider adapter for a {@link org.eclipse.mddi.modelbus.description.ModelBusPackaging} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class ModelBusPackagingItemProvider
	extends ItemProviderAdapter
	implements	
		IEditingDomainItemProvider,	
		IStructuredItemContentProvider,	
		ITreeItemContentProvider,	
		IItemLabelProvider,	
		IItemPropertySource {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = "Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.  All rights reserved.This software is published under the terms of the ModelBus Software License in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. A copy of ModelBus Software License is provided with this distribution in doc/LICENSE.txt file.";

	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ModelBusPackagingItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addNamePropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Name feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addNamePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_ModelBusPackaging_name_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_ModelBusPackaging_name_feature", "_UI_ModelBusPackaging_type"),
				 DescriptionPackage.Literals.MODEL_BUS_PACKAGING__NAME,
				 true,
				 false,
				 false,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This specifies how to implement {@link #getChildren} and is used to deduce an appropriate feature for an
	 * {@link org.eclipse.emf.edit.command.AddCommand}, {@link org.eclipse.emf.edit.command.RemoveCommand} or
	 * {@link org.eclipse.emf.edit.command.MoveCommand} in {@link #createCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Collection getChildrenFeatures(Object object) {
		if (childrenFeatures == null) {
			super.getChildrenFeatures(object);
			childrenFeatures.add(DescriptionPackage.Literals.MODEL_BUS_PACKAGING__CONTENT);
		}
		return childrenFeatures;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EStructuralFeature getChildFeature(Object object, Object child) {
		// Check the type of the specified child object and return the proper feature to use for
		// adding (see {@link AddCommand}) it as a child.

		return super.getChildFeature(object, child);
	}

	/**
	 * This returns ModelBusPackaging.gif.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object getImage(Object object) {
		return overlayImage(object, getResourceLocator().getImage("full/obj16/ModelBusPackaging"));
	}

	/**
	 * This returns the label text for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getText(Object object) {
		String label = ((ModelBusPackaging)object).getName();
		return label == null || label.length() == 0 ?
			getString("_UI_ModelBusPackaging_type") :
			getString("_UI_ModelBusPackaging_type") + " " + label;
	}

	/**
	 * This handles model notifications by calling {@link #updateChildren} to update any cached
	 * children and by creating a viewer notification, which it passes to {@link #fireNotifyChanged}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void notifyChanged(Notification notification) {
		updateChildren(notification);

		switch (notification.getFeatureID(ModelBusPackaging.class)) {
			case DescriptionPackage.MODEL_BUS_PACKAGING__NAME:
				fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), false, true));
				return;
			case DescriptionPackage.MODEL_BUS_PACKAGING__CONTENT:
				fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), true, false));
				return;
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds {@link org.eclipse.emf.edit.command.CommandParameter}s describing the children
	 * that can be created under this object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void collectNewChildDescriptors(Collection newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);

		newChildDescriptors.add
			(createChildParameter
				(DescriptionPackage.Literals.MODEL_BUS_PACKAGING__CONTENT,
				 DescriptionFactory.eINSTANCE.createModelBusPackaging()));

		newChildDescriptors.add
			(createChildParameter
				(DescriptionPackage.Literals.MODEL_BUS_PACKAGING__CONTENT,
				 AbstractFactory.eINSTANCE.createModelingServiceInterface()));

		newChildDescriptors.add
			(createChildParameter
				(DescriptionPackage.Literals.MODEL_BUS_PACKAGING__CONTENT,
				 AbstractFactory.eINSTANCE.createModelingService()));

		newChildDescriptors.add
			(createChildParameter
				(DescriptionPackage.Literals.MODEL_BUS_PACKAGING__CONTENT,
				 AbstractFactory.eINSTANCE.createParameter()));

		newChildDescriptors.add
			(createChildParameter
				(DescriptionPackage.Literals.MODEL_BUS_PACKAGING__CONTENT,
				 AbstractFactory.eINSTANCE.createModelType()));

		newChildDescriptors.add
			(createChildParameter
				(DescriptionPackage.Literals.MODEL_BUS_PACKAGING__CONTENT,
				 AbstractFactory.eINSTANCE.createPrimitiveType()));

		newChildDescriptors.add
			(createChildParameter
				(DescriptionPackage.Literals.MODEL_BUS_PACKAGING__CONTENT,
				 AbstractFactory.eINSTANCE.createEnumerationType()));

		newChildDescriptors.add
			(createChildParameter
				(DescriptionPackage.Literals.MODEL_BUS_PACKAGING__CONTENT,
				 AbstractFactory.eINSTANCE.createError()));

		newChildDescriptors.add
			(createChildParameter
				(DescriptionPackage.Literals.MODEL_BUS_PACKAGING__CONTENT,
				 AbstractFactory.eINSTANCE.createMetaclassSpecification()));

		newChildDescriptors.add
			(createChildParameter
				(DescriptionPackage.Literals.MODEL_BUS_PACKAGING__CONTENT,
				 AbstractFactory.eINSTANCE.createEvent()));

		newChildDescriptors.add
			(createChildParameter
				(DescriptionPackage.Literals.MODEL_BUS_PACKAGING__CONTENT,
				 ConcreteFactory.eINSTANCE.createTool()));

		newChildDescriptors.add
			(createChildParameter
				(DescriptionPackage.Literals.MODEL_BUS_PACKAGING__CONTENT,
				 ConcreteFactory.eINSTANCE.createProperty()));

		newChildDescriptors.add
			(createChildParameter
				(DescriptionPackage.Literals.MODEL_BUS_PACKAGING__CONTENT,
				 DatatypeFactory.eINSTANCE.createFile()));
	}

	/**
	 * Return the resource locator for this item provider's resources.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ResourceLocator getResourceLocator() {
		return ModelbusEditPlugin.INSTANCE;
	}

}
