/**
 * <copyright>
 * </copyright>
 *
 * $Id: ModelingServiceInterfaceImpl.java,v 1.3 2007/04/18 13:50:41 xblanc Exp $
 */
package org.eclipse.mddi.modelbus.description.abstract_.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.mddi.modelbus.description.abstract_.AbstractPackage;
import org.eclipse.mddi.modelbus.description.abstract_.Event;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingService;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingServiceInterface;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Modeling Service Interface</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.mddi.modelbus.description.abstract_.impl.ModelingServiceInterfaceImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.mddi.modelbus.description.abstract_.impl.ModelingServiceInterfaceImpl#getService <em>Service</em>}</li>
 *   <li>{@link org.eclipse.mddi.modelbus.description.abstract_.impl.ModelingServiceInterfaceImpl#getPublishedEvent <em>Published Event</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ModelingServiceInterfaceImpl extends EObjectImpl implements ModelingServiceInterface {
    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public static final String copyright = "Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.  All rights reserved.This software is published under the terms of the ModelBus Software License in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. A copy of ModelBus Software License is provided with this distribution in doc/LICENSE.txt file.";

    /**
     * The default value of the '{@link #getName() <em>Name</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getName()
     * @generated
     * @ordered
     */
    protected static final String NAME_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getName()
     * @generated
     * @ordered
     */
    protected String name = NAME_EDEFAULT;

    /**
     * The cached value of the '{@link #getService() <em>Service</em>}' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getService()
     * @generated
     * @ordered
     */
    protected EList service;

    /**
     * The cached value of the '{@link #getPublishedEvent() <em>Published Event</em>}' reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getPublishedEvent()
     * @generated
     * @ordered
     */
    protected EList publishedEvent;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ModelingServiceInterfaceImpl() {
        super();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EClass eStaticClass() {
        return AbstractPackage.Literals.MODELING_SERVICE_INTERFACE;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getName() {
        return name;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setName(String newName) {
        String oldName = name;
        name = newName;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, AbstractPackage.MODELING_SERVICE_INTERFACE__NAME, oldName, name));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EList getService() {
        if (service == null) {
            service = new EObjectContainmentEList(ModelingService.class, this, AbstractPackage.MODELING_SERVICE_INTERFACE__SERVICE);
        }
        return service;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EList getPublishedEvent() {
        if (publishedEvent == null) {
            publishedEvent = new EObjectResolvingEList(Event.class, this, AbstractPackage.MODELING_SERVICE_INTERFACE__PUBLISHED_EVENT);
        }
        return publishedEvent;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case AbstractPackage.MODELING_SERVICE_INTERFACE__SERVICE:
                return ((InternalEList)getService()).basicRemove(otherEnd, msgs);
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case AbstractPackage.MODELING_SERVICE_INTERFACE__NAME:
                return getName();
            case AbstractPackage.MODELING_SERVICE_INTERFACE__SERVICE:
                return getService();
            case AbstractPackage.MODELING_SERVICE_INTERFACE__PUBLISHED_EVENT:
                return getPublishedEvent();
        }
        return super.eGet(featureID, resolve, coreType);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case AbstractPackage.MODELING_SERVICE_INTERFACE__NAME:
                setName((String)newValue);
                return;
            case AbstractPackage.MODELING_SERVICE_INTERFACE__SERVICE:
                getService().clear();
                getService().addAll((Collection)newValue);
                return;
            case AbstractPackage.MODELING_SERVICE_INTERFACE__PUBLISHED_EVENT:
                getPublishedEvent().clear();
                getPublishedEvent().addAll((Collection)newValue);
                return;
        }
        super.eSet(featureID, newValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eUnset(int featureID) {
        switch (featureID) {
            case AbstractPackage.MODELING_SERVICE_INTERFACE__NAME:
                setName(NAME_EDEFAULT);
                return;
            case AbstractPackage.MODELING_SERVICE_INTERFACE__SERVICE:
                getService().clear();
                return;
            case AbstractPackage.MODELING_SERVICE_INTERFACE__PUBLISHED_EVENT:
                getPublishedEvent().clear();
                return;
        }
        super.eUnset(featureID);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case AbstractPackage.MODELING_SERVICE_INTERFACE__NAME:
                return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
            case AbstractPackage.MODELING_SERVICE_INTERFACE__SERVICE:
                return service != null && !service.isEmpty();
            case AbstractPackage.MODELING_SERVICE_INTERFACE__PUBLISHED_EVENT:
                return publishedEvent != null && !publishedEvent.isEmpty();
        }
        return super.eIsSet(featureID);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String toString() {
        if (eIsProxy()) return super.toString();

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(name);
        result.append(')');
        return result.toString();
    }

} //ModelingServiceInterfaceImpl
