/*
 * $RCSfile: AdapterContainer.java,v $
 * $Date: 2006/06/21 11:58:54 $
 * $Revision: 1.5 $
 * $Author: xblanc $
 */
 
/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */
 
/*
 * AdapterContainer.java
 * 
 * @author Prawee Sriplakich
 * @version $Revision: 1.5 $ $Date: 2006/06/21 11:58:54 $

 */
package org.eclipse.mddi.modelbus.adapter.infrastructure;

import java.util.Collection;

import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;
import org.eclipse.mddi.modelbus.description.concrete.Tool;

public interface AdapterContainer {

    
    /**
     * Deploys an Adapter to this server, so 1) it begins accepting service
     * invocation, and 2) receiving notifications.
     * 
     * 
     * @param adapter
     *            the Adapter object
     * @throws DeploymentException
     */    
    public void deployAdapter(AdapterStub adapter) throws DeploymentException;
    
    /**
     * Undeploys an Adapter to this server. The result is 1) it will not accept
     * invocation anymore, and 2) it will not accept notifications anymore.
     * 
     * @param adapter
     *            the Adapter object
     * @throws DeploymentException
     */
    public void undeployAdapter(AdapterStub adapter) throws DeploymentException;    
    
    
    public boolean containsTool(Tool toolDesc);
    
    public Collection getAdapters();
}
