/*
 * $RCSfile: RootLogger.java,v $
 * $Date: 2007/05/09 13:18:18 $
 * $Revision: 1.3 $
 * $Author: xblanc $
 */
 
/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */
 
/*
 * LoggerConfigurator.java
 * 
 * @author Andrey Sadovykh (LIP6)
 * @version $Revision: 1.3 $ $Date: 2007/05/09 13:18:18 $
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure;


import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;


public class RootLogger {
    
    
    private static Logger logger;
    
    
    static class ShortFormatter extends Formatter {

        static final String prefix = "org.eclipse.mddi.modelbus.";
        
        @Override
        public String format(LogRecord record) {
            StringBuffer sb = new StringBuffer();
            if (record.getSourceClassName() != null) {  
                String clazz = record.getSourceClassName();
                if(clazz.startsWith(prefix)) {
                    clazz = clazz.substring(prefix.length());
                }
                sb.append(clazz);
            } else {
                sb.append(record.getLoggerName());
            }
            sb.append(" ");
            sb.append(record.getLevel().getLocalizedName());
            sb.append(": ");
            String message = record.getMessage();
            sb.append(message);
            if (record.getThrown() != null) {
                try {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    record.getThrown().printStackTrace(pw);
                    pw.close();
                sb.append(" ");
                sb.append(sw.toString());
                } catch (Exception ex) {
                }
            }
            sb.append("\n");
            return sb.toString();
            
        }
        
    }
    
    
    public static Logger getLogger() {
        if(logger == null) {
            logger = Logger.getLogger("org.eclipse.mddi.modelbus");
            ConsoleHandler h = new ConsoleHandler();
            h.setFormatter(new ShortFormatter());
            h.setLevel(Level.ALL);
            
            logger.addHandler(h);
            logger.setUseParentHandlers(false);
            logger.setLevel(Level.ALL);
            
            //disable other loggers
            org.apache.log4j.Logger.getRootLogger().setLevel(org.apache.log4j.Level.FATAL);
            
            org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger.getLogger().log(Level.FINE, "Logger configured");                 
        }
        return logger;
    }
        

}
