/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */



package org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.mb_xmi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import java.util.logging.Level;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.DefaultModelSerializer;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.DeserializedModel;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.SerializedXmiDocument;
import org.xml.sax.SAXException;

/**
 * This serilaizer is used for copy-restore invocation 
 * 
 * @author Prawee Sriplakich (Prawee.Sriplakich[at]lip6.fr)
 *
 */
public class IdModelSerializer extends DefaultModelSerializer {

    public IdModelSerializer() {
        setSkipCrossReferences(true);
    }

    

    protected void saveResource(Resource r, OutputStream out) throws IOException {
       MBModelSerializer ser = new MBModelSerializer();
       ser.serializeResource(r, out);
    }

    protected void loadResource(Resource r, InputStream in) throws IOException {
        MBModelDeserializer deser = new MBModelDeserializer(r);
        try {
            deser.deserialize(in);
        } catch (SAXException e) {
            throw new IOException(e.toString());
        } 
        
        


    }
    
    public DeserializedModel[] deserialize(SerializedXmiDocument[] documents) {
        DeserializedModel[] result = super.deserialize(documents);
        if(inoutResourceSet!=null) {
            
          RestoreManager rm = new RestoreManager();
          // avoid ConcurrentModificationException
          for(Resource newResource : new Vector<Resource>(inoutResourceSet.getResources())) {
            URI uri = newResource.getURI();
            Resource r = ModelUtil.findResourceWithURI(uri.toString(), sentResources);
            if(r==null)  {
                ModelUtil.findResourceWithURI(uri.toString(), defaultReceivedResourceSet);
            }
            if(r!=null) {
              rm.update(r, newResource);
            } else {
              RootLogger.getLogger().log(Level.WARNING, "resource not found for restoration " + uri);
            }
          }
        }
        
        return result;
    }
    
    protected String getReference(EObject o) {
        return IdTableRegistry.getId(o);
    }
    
    protected EObject dereference(Resource r, String fragment) {
        if(r.getResourceSet() == inoutResourceSet) {
            // the model element will be restored, 
            // therefore the point should point to the original element 
            Resource r2 = defaultReceivedResourceSet.getResource(r.getURI(), false);
            IdTableRegistry.getIdTable(r2).getModelElement(fragment);
        }
        return IdTableRegistry.getIdTable(r).getModelElement(fragment);
    }
}
