/*
 * $RCSfile: ModelBaseURIConverter.java,v $
 * $Date: 2007/06/09 12:03:57 $
 * $Revision: 1.1 $
 * $Author: xblanc $
 */

/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * ModelBaseURIConverter.java Add description 
 * 
 * @author Prawee Sriplakich
 * @version $Revision: 1.1 $ $Date: 2007/06/09 12:03:57 $
 * @see Add references
 *
 * TODO Add description
 * TODO Add references
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.mb_xmi;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger;

public class ModelBaseURIConverter extends URIConverterImpl {


    public static String REPOSITORY_SCHEME = "repository";
    
    
    public static boolean hasRepositoryScheme(URI uri) {
        return REPOSITORY_SCHEME.equals(uri.scheme());
    }

    protected String localEnvironmentPath = null;

    protected File localEnvironment = null;



    public ModelBaseURIConverter() {
    }

    /**
     * 
     * transform the Uri to the environment-independant form : Ex. from
     * [environmentPath]/folder1/resource1.xml to
     * repository:/folder1/resource1.xml
     * 
     * @param uri
     * @return the normalized URI
     * 
     */
    public URI normalize(URI uri) {
        /*
         * if this URI reference a moved element, then map it to the destination
         * model URI.
         */
        if (hasRepositoryScheme(uri)) {
            return uri;
        }
        if (localEnvironmentPath != null && uri.isFile()) {
            try {
                String filePath = new File(uri.toFileString())
                        .getCanonicalPath();
                if (filePath.startsWith(localEnvironmentPath)) {
                    String path = filePath.substring(localEnvironmentPath
                            .length());
                    URI uri2 = createRepositoryURI(path);
                    return uri2;
                }
            } catch (IOException e) {
                 RootLogger.getLogger().log(Level.SEVERE, "error resolving " + uri + " " + e);
            }
        }
        return super.normalize(uri);
    }

    public InputStream createInputStream(URI uri) throws IOException {
        File f = getFile(uri);
        if (f != null) {
            return new FileInputStream(f);
        }
        try {
          return super.createInputStream(uri);
        } catch(Exception e) {
          throw new IOException(e.toString() +" uri=" + uri);
        }
    }

    public OutputStream createOutputStream(URI uri) throws IOException {
        File f = getFile(uri);
        if (f != null) {
            return new FileOutputStream(f);
        }
        try {
          return super.createOutputStream(uri);
        } catch(Exception e) {
            throw new IOException(e.toString() +" uri=" + uri);
        }
    }

    /**
     * Resolve the URL to file
     * 
     * @param uri
     * @return null if the URI cannot be converted to the repository sche                  me
     */
    protected File getFile(URI uri) {
        if (!hasRepositoryScheme(uri)) {
            uri = normalize(uri);
        }
        if (hasRepositoryScheme(uri) && localEnvironment != null) {
            return new File(localEnvironment, uri.path());
        }
        return null;
    }




    /**
     * @return Returns the localEnvironmentPath.
     */
    public File getLocalEnvironment() {
        return localEnvironment;
    }

    public void setLocalEnvironment(File localEnvironment) throws IOException {
        if (localEnvironment == null) {
            this.localEnvironment = null;
            this.localEnvironmentPath = null;
        } else {
            this.localEnvironment = localEnvironment.getCanonicalFile();
            this.localEnvironmentPath = localEnvironment.getCanonicalPath();
        }
    }

    public static URI createRepositoryURI(String filePath) {
        filePath = filePath.replace('\\', '/');
        if (filePath.startsWith("/")) {
            return URI.createURI(REPOSITORY_SCHEME + ":" + filePath);
        }
        return URI.createURI(REPOSITORY_SCHEME + ":/" + filePath);
    }


    
}