/*
 * $RCSfile: NotificationProtocol.java,v $
 * $Date: 2006/10/10 09:08:25 $
 * $Revision: 1.1 $
 * $Author: xblanc $
 */

/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * NotificationService.java Add description 
 * 
 * @author Prawee Sriplakich
 * @version $Revision: 1.1 $ $Date: 2006/10/10 09:08:25 $
 * @see Add references
 *
 * TODO Add description
 * TODO Add references
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.notification;

import javax.xml.soap.SOAPBody;

/**
 * 
 * Notification protocol encapsulates the mechanism to interact 
 * with the notification server.
 * 
 * @author Prawee Sriplakich (LIP6)
 *
 *
 */
public interface NotificationProtocol {

    public abstract void subscribe(String notificationBrokerEndpoint,
            String notificationConsumerEndpoint, String[] topics)
            throws NotifServiceNotAvailableException;

    public abstract void unsubscribe();

    public abstract void publish(String notificationBrokerEndpoint,
            String topicExpression, String message);

    /**
     * Extracts notifications from a SOAP body
     * 
     * @param body the notifications encoded as SOAP body
     * @return
     * 
     */
    public abstract SerializedNotification[] extractNotifications(SOAPBody body);

}