/*
 * $RCSfile: AdminRemoveTool.java,v $
 * $Date: 2006/10/10 09:08:26 $
 * $Revision: 1.1 $
 * $Author: xblanc $
 */
 
/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */
 
/*
 * RemoveTool.java Add description 
 * 
 * @author Prawee Sriplakich
 * @version $Revision: 1.1 $ $Date: 2006/10/10 09:08:26 $
 * @see Add references
 *
 * TODO Add description
 * TODO Add references
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.registry;

import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;

import javax.xml.rpc.ServiceException;

import org.eclipse.mddi.modelbus.adapter.infrastructure.registry.ws.InvalidToken;
import org.eclipse.mddi.modelbus.adapter.infrastructure.registry.ws.WebRegistry;
import org.eclipse.mddi.modelbus.adapter.infrastructure.registry.ws.WebRegistryServiceLocator;

/**
 * 
 * Remove a tool from the registry
 * used for managing the registry
 * 
 * @author Prawee Sriplakich (LIP6)
 *
 *
 */
public class AdminRemoveTool {



    /**
     * Remove a tool description from the registry.
     * Using in admin purpose
     * 
     * @param args
     * <p>args[0] the token of the tool to remove.
     * 
     * <p>args[1] the registry URL (optional: The default one is used if not specified)
     * @throws Exception 
     */
    public static void main(String[] args) throws ServiceException, InvalidToken, RemoteException, MalformedURLException {
        if(args.length<1) {
            System.out.println("Please specify command line parameters !");
            System.exit(0);
        }
        
        String token = args[0];
        
        String registryUrl = "http://localhost:8082/modelbus/modelwareRegistry";
        if(args.length>1) {
            registryUrl = args[1];
        }

        System.out.println("Removing tool description...");
        System.out.println("Registry URL = "  +registryUrl);
        System.out.println("Tool Token = " +token);
        
        WebRegistryServiceLocator loc = new WebRegistryServiceLocator();
        WebRegistry r = loc.getWebRegistry(new URL(registryUrl));
        r.deregisterTool(token);

        System.out.println("Tool " +token +" removed :) ");

    }

}
