/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */



package org.eclipse.mddi.modelbus.adapter.infrastructure.transport;


import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mddi.modelbus.adapter.user.consumer.GenericConsumer;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelBusCommunicationException;


public class RepositoryClient implements Repository {
    
    
    static URL getRepositoryUrl(String modelUri) throws ModelBusCommunicationException{
        URI uri = URI.createURI(modelUri);
        URL url;
        try {
            url = new URL(uri.trimFragment().toString());
            return url;
            
        } catch (MalformedURLException e) {
            throw new ModelBusCommunicationException(e);
        }

    }
    
    
    GenericConsumer consumer;
    
    public RepositoryClient(GenericConsumer c) {
        this.consumer = c;
    }
    
    public List<EObject> getModel(String uri) throws ModelBusCommunicationException {
        Map input = new Hashtable();
        input.put("uri", uri);
        URL repositoryUrl = getRepositoryUrl(uri);
        
        Map output = consumer.consume(repositoryUrl, "modelbus_repository.getModel", input);
        
        return (List<EObject>) output.get("model");
    }
    
    
 

    public void putModel(String uri, List<EObject> model) throws ModelBusCommunicationException{
        Map input = new Hashtable();
        input.put("uri", uri);
        URL repositoryUrl = getRepositoryUrl(uri);
        consumer.consume(repositoryUrl, "modelbus_repository.putModel", input);
    }

}
