/*
 * $RCSfile: SessionManager.java,v $
 * $Date: 2007/06/07 13:33:39 $
 * $Revision: 1.6 $
 * $Author: xblanc $
 */

/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * SessionManager.java  
 * 
 * @author Andrey Sadovykh (LIP6)
 * @version $Revision: 1.6 $ $Date: 2007/06/07 13:33:39 $
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

import org.eclipse.emf.common.util.EList;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingService;
import org.eclipse.mddi.modelbus.description.concrete.Tool;

public class SessionManager {
    

    /**
     * Sessions Map associates sessionId to a SessionProviderProxy
     * 
     */
    private Map sessions = new Hashtable();

    /**
     * 
     * getProviderProxy returns a SessionProviderProxy for a given sessionId
     * 
     * @param sessionId
     * @return SessionProviderProxy
     * 
     */
    public SessionProviderProxy getProviderProxy(String sessionId) {

        return (SessionProviderProxy) (sessions.get(sessionId));
    }

    public void putProviderProxy(String sessionId, SessionProviderProxy proxy) {
        sessions.put(sessionId, proxy);
    }

    public void removeSession(String sessionId) {
        sessions.remove(sessionId);
    }

    public String[] getAllOpenSessions() {
        String[] sessionsArray;
        sessionsArray = (String[]) sessions.keySet().toArray();
        return sessionsArray;
    }

    public String[] getOpenSessions(String serviceName) {
        List<String> returnSessionIdsSet = new Vector();

        QualifiedServiceName qname = QualifiedServiceName
                .getQualifiedServiceName(serviceName);

        Iterator it = sessions.values().iterator();
        // check all Proxies
        for (int index = 0; it.hasNext(); index++) {
            SessionProviderProxy testProxy = (SessionProviderProxy) it.next();
            Tool tool = testProxy.getToolDescription();
            // check tool name
            if (qname.interfaceName != null) {
                // check only interfaceName
                if (qname.toolName != null) {
                    // check toolName matching
                    if (tool.getName().matches(qname.toolName)
                            || tool.getInterface().getName().matches(
                                    qname.interfaceName)) {
                        String sessionId = (String) ((Vector) sessions.keySet())
                                .get(index);
                        returnSessionIdsSet.add(sessionId);
                    }
                } else if (tool.getInterface().getName().matches(
                        qname.interfaceName)) {
                    String sessionId = (String) ((Vector) sessions.keySet())
                            .get(index);
                    returnSessionIdsSet.add(sessionId);
                }
            } else {
                // check only for serviceName of all services
                EList serviceList = tool.getInterface().getService();
                boolean isFound = false;
                for (int i = 0; (i < serviceList.size()) || isFound; i++) {
                    ModelingService ms = (ModelingService) serviceList.get(i);
                    if (ms.getName().matches(qname.serviceName)) {
                        isFound = true;
                        String sessionId = (String) ((Vector) sessions.keySet())
                                .get(index);
                        returnSessionIdsSet.add(sessionId);
                    }
                }
            }
        }

        return returnSessionIdsSet.toArray(new String[0]);
    }
}
