/*
 * $RCSfile: DefaultSessionMarshaler.java,v $
 * $Date: 2007/06/09 02:33:10 $
 * $Revision: 1.6 $
 * $Author: xblanc $
 */

/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * DefaultSessionMarshaler.java Add description 
 * 
 * @author Andrey Sadovykh (LIP6)
 * @version $Revision: 1.6 $ $Date: 2007/06/09 02:33:10 $
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;

import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelBusCommunicationException;
import org.eclipse.mddi.modelbus.description.abstract_.Parameter;

public class DefaultSessionMarshaler extends DefaultMarshaler {


    public static final String SESSION_ID_TAG = "modelbus:sessionId";

    private String sessionId = null;

    
    public DefaultSessionMarshaler() {
        super();
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.mddi.modelbus.adapter.infrastructure.transport.marshal.ws.AbstractMarshaler#marshal(org.eclipse.mddi.modelbus.description.abstract_.Parameter[],
     *      java.lang.Object[], javax.xml.soap.SOAPElement)
     */
    public void marshal(List<Parameter> params, Map<String, Object> parameterValues,
            SOAPElement topElem) throws SOAPException {
        SOAPElement sessionIdElem = topElem.addChildElement(SESSION_ID_TAG);
        sessionIdElem.addTextNode(sessionId);
        
        if(parameterValues!=null) {
          super.marshal(params, parameterValues, topElem);
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.mddi.modelbus.adapter.infrastructure.transport.marshal.ws.AbstractMarshaler#unmarshal(org.eclipse.mddi.modelbus.description.abstract_.Parameter[],
     *      javax.xml.soap.SOAPElement)
     */
    public Map unmarshal(List<Parameter> params, SOAPElement topElem)
            throws SOAPException, ModelBusCommunicationException {
        Iterator it = topElem.getChildElements();
        SOAPElement sessionEl = (SOAPElement) it.next();
        if (sessionEl.getNodeName().matches(SESSION_ID_TAG)) {
            // retrieve and remove sessionId
            sessionId = sessionEl.getValue();
            topElem.removeChild(sessionEl);
        }
        return super.unmarshal(params, topElem);
    }

    /**
     * @return the sessionId
     */
    public String getSessionId() {
        return sessionId;
    }

    /**
     * @param sessionId the sessionId to set
     */
    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }


}
