/*
 * $RCSfile: DefaultSessionWsInvocationReceiver.java,v $
 * $Date: 2007/06/09 01:33:12 $
 * $Revision: 1.4 $
 * $Author: xblanc $
 */

/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * DefaultSessionWsInvocationReceiver.java 
 * 
 * @author Andrey Sadovykh (LIP6)
 * @version $Revision: 1.4 $ $Date: 2007/06/09 01:33:12 $
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws;

import java.util.List;
import java.util.logging.Level;

import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;

import org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.DescriptionUtil;
import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;
import org.eclipse.mddi.modelbus.adapter.user.InvalidSession;
import org.eclipse.mddi.modelbus.adapter.user.ModelingServiceError;
import org.eclipse.mddi.modelbus.adapter.user.SessionNeeded;
import org.eclipse.mddi.modelbus.adapter.user.provider.GenericSessionProvider;
import org.eclipse.mddi.modelbus.description.abstract_.Parameter;

/**
 * DefaultSessionWsInvocationReceiver parses incomming SOAP messages and
 * executes services in the session mode
 * 
 * @author Andrey Sadovykh (LIP6)
 */
public class DefaultSessionWsInvocationReceiver extends
        DefaultWsInvocationReceiver {

    /**
     * Service call processing trigger (newSession, endSession). It is trigered
     * when the incomming call is dedicated to a modeling service.
     */
    boolean isModelingSeriviceCall = false;

    /**
     * @param adapter
     */
    public DefaultSessionWsInvocationReceiver(AdapterStub adapter) {
        super(adapter);
        marshaler = new DefaultSessionMarshaler();
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.DefaultWsInvocationReceiver#performService()
     */
    public void performService() throws SessionNeeded, ModelingServiceError,
            InvalidSession {
        if (isModelingSeriviceCall) {
            GenericSessionProvider si = adapter.getToolStub().getSessionProvider();
            String serviceName = ms.getName();
            
            Parameter[] inputParams = (Parameter[]) DescriptionUtil.get_in_inout_Parameters(ms).toArray(new Parameter[0]);
            Parameter[] outputParams = (Parameter[]) DescriptionUtil.get_out_inout_Parameters(ms).toArray(new Parameter[0]);
            Object[] inputArray, outputArray;
            inputArray = DescriptionUtil.map2Array(inputParams, inputs);
            outputArray  = si.executeSession(serviceName,
                    inputArray, ((DefaultSessionMarshaler) marshaler)
                    .getSessionId());

            outputs = DescriptionUtil.array2Map(outputParams, outputArray);
            
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.DefaultWsInvocationReceiver#createResponse()
     */
    public void createResponse() throws Exception {
        // because of DefaultWsInvocationReceiver implementation
        // it is applicable for service calls only
        if (isModelingSeriviceCall) {
            super.createResponse();
        }
    }

    /**
     * newSession porcesses incomming calls for newSession operation
     * 
     * @throws Exception
     * 
     */
    public void newSession() throws Exception {
        GenericSessionProvider si = adapter.getToolStub()
                .getSessionProvider();
        
        String sessionId = si.newSession();
        
        RootLogger.getLogger().log(Level.INFO,"Sender Session ID"+ sessionId);

        SOAPBody responsebody = resMsg.getBody();
        DefaultMarshaler.setNamespaces(responsebody);
        
        SOAPElement resTopElem = responsebody.addChildElement( DefaultSessionWsInvocationSender.NEW_SESSION_TAG +"Response", "modelbus");
     
        // marshall sessionID
        ((DefaultSessionMarshaler)getMarshaler()).setSessionId(sessionId);
        getMarshaler().marshal((List<Parameter>) null, null, resTopElem);
        
        RootLogger.getLogger().log(Level.INFO,"Res:"+ responsebody);

    }

    /**
     * endSession porcesses incomming calls for endSession operation
     * 
     * @throws Exception
     * 
     */
    void endSession() throws Exception {
        SOAPBody requestbody = reqMsg.getBody();
        // the first child in the SOAP body is a input message conforming to
        // WSDL
        SOAPElement reqTopElem = SoapUtil.getFirstChild(requestbody);
        marshaler.unmarshal((List<Parameter>) null, reqTopElem);

        String sessionId = ((DefaultSessionMarshaler)marshaler).getSessionId();

        GenericSessionProvider si = adapter.getToolStub()
                .getSessionProvider();

        si.endSession(sessionId);

        SOAPBody responsebody = resMsg.getBody();
        DefaultMarshaler.setNamespaces(responsebody);
        
        responsebody.addChildElement( DefaultSessionWsInvocationSender.END_SESSION_TAG +"Response", "modelbus");
    }

    /**
     * Reads the content in the HTTP request
     * 
     * @throws Exception
     * @see org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.DefaultWsInvocationReceiver#readRequest()
     */
    public void readRequest() throws Exception {

        SOAPBody requestbody = reqMsg.getBody();
        // the first child in the SOAP body is a input message conforming to
        // WSDL
        SOAPElement reqTopElem = SoapUtil.getFirstChild(requestbody);
        if (reqTopElem == null) {
             org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger.getLogger().log(Level.SEVERE, "SERVER: receive empty request");
             org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger.getLogger().log(Level.INFO, reqMsg.toString() );
            throw new SOAPException("Empty SOAP request");
        }

        String serviceName = reqTopElem.getLocalName();

        if (serviceName
                .equals(DefaultSessionWsInvocationSender.NEW_SESSION_TAG)) {
            newSession();
            return;
        } else if (serviceName
                .equals(DefaultSessionWsInvocationSender.END_SESSION_TAG)) {
            endSession();
            return;
        }

        isModelingSeriviceCall = true;

        super.readRequest();
    }

}
