/*
 * $RCSfile: DefaultTransportManager.java,v $
 * $Date: 2007/08/24 16:04:55 $
 * $Revision: 1.8 $
 * $Author: xblanc $
 */
 
/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */
 
/*
 * DefaultTransport.java Add description 
 * 
 * @author Prawee Sriplakich
 * @version $Revision: 1.8 $ $Date: 2007/08/24 16:04:55 $
 * @see Add references
 *
 * TODO Add description
 * TODO Add references
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws;

import java.net.URL;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;

import org.eclipse.mddi.modelbus.adapter.infrastructure.AdapterContainerImpl;
import org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.DescriptionUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.mb_xmi.IdModelSerializerFactory;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.uml2.ProfiledModelSerializerFactory;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.DefaultModelSerializerFactory;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.ModelSerializerFactory;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ProviderProxy;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.SessionManager;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.SessionProviderProxy;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.local.LocalInvocationSender;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.local.LocalSessionInvocationSender;
import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelBusCommunicationException;
import org.eclipse.mddi.modelbus.description.concrete.Tool;

public class DefaultTransportManager implements TransportManager {

    
    SessionManager sessionManager = new SessionManager();
    
    AdapterStub adapter;
    
    
    /**
     * The model serializer factory to be used by default
     */
    ModelSerializerFactory defaultModelSerializerFactory;
    
    /**
     * List of all installed model serializer factories
     */
    List modelSerializerFactorySet = new Vector();
    
    public DefaultTransportManager(AdapterStub a) {
        adapter = a;
        
        defaultModelSerializerFactory = new DefaultModelSerializerFactory();
        
        modelSerializerFactorySet.add(defaultModelSerializerFactory);
        modelSerializerFactorySet.add(new IdModelSerializerFactory());
        modelSerializerFactorySet.add(new ProfiledModelSerializerFactory());
    }
    
    
    public ProviderProxy createProviderProxy(URL url) {
        DefaultWsInvocationSender p = new DefaultWsInvocationSender();
        p.setToolUrl(url);
        p.getMarshaler().setModelSerializerFactory(defaultModelSerializerFactory);
        return p;
    }
    
    
    public ProviderProxy createProviderProxy(Tool t) throws ModelBusCommunicationException {
        ProviderProxy p = null;
        // if local AdapterContainer contains Tool t
        if (AdapterContainerImpl.getInstance().containsTool(t)) {

             org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger.getLogger().log(Level.INFO,"Local Call");

            p = new LocalInvocationSender();
        } else {
            p = new DefaultWsInvocationSender();
        }   
        p.setToolDescription(t);
        // choose the model serializer to communicating with the server tool
        p.getMarshaler().setModelSerializerFactory(defaultModelSerializerFactory);
        
        return p;
    }

    public SessionProviderProxy createSessionProviderProxy(Tool t) throws ModelBusCommunicationException {
        SessionProviderProxy p = null;
        if (!DescriptionUtil.getIsSessionEnabled(t))
            return p;
        // if local AdapterContainer contains Tool t
        if (AdapterContainerImpl.getInstance().containsTool(t)) {
            p = new LocalSessionInvocationSender();
        } else
            p = new DefaultSessionWsInvocationSender();

        p.setSessionManager(sessionManager);
        p.setToolDescription(t);
        // choose the model serializer to communicating with the server tool
        p.getMarshaler().setModelSerializerFactory(defaultModelSerializerFactory);
        return p;
    }

    public WsInvocationReceiver createWsInvocationReceiver() {
        WsInvocationReceiver r;

        if (DescriptionUtil.getIsSessionEnabled(adapter.getToolDescription())) {
            // Session case
            r = new DefaultSessionWsInvocationReceiver(adapter);
        } else {
            r = new DefaultWsInvocationReceiver(adapter);
        }
        return r;
    }
    
    /*
     *  (non-Javadoc)
     * @see org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.TransportManager#setDefaultModelSerializerFactory(org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.ModelSerializerFactory)
     */
    public void setDefaultModelSerializerFactory(
            ModelSerializerFactory modelSerializerFactory) {
        if(modelSerializerFactory==null) {
            RootLogger.getLogger().log(Level.INFO,"Default model serializer factory cannot be set to null.");
            return;
        }
        if(!modelSerializerFactorySet.contains(modelSerializerFactory)) {
            modelSerializerFactorySet.add(modelSerializerFactory);
        }
        this.defaultModelSerializerFactory = modelSerializerFactory;
    }
    

    /*
     *  (non-Javadoc)
     * @see org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.TransportManager#getModelSerializerFactoryList()
     */
    public List getModelSerializerFactoryList()   {
        return modelSerializerFactorySet;
    }
    

    /*
     *  (non-Javadoc)
     * @see org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.TransportManager#getModelSerializerFactory(java.lang.String)
     */
    public ModelSerializerFactory findModelSerializerFactory(String name) {
      for(int i=0; i<modelSerializerFactorySet.size(); i++) {
          ModelSerializerFactory f = (ModelSerializerFactory) 
              modelSerializerFactorySet.get(i);
          if(f.getName().equals(name)) {
            return f;
          }
      } 
      org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger.getLogger().log(Level.INFO,"Model serializer factory not found: " + name 
              +", Returning " +defaultModelSerializerFactory);
      return defaultModelSerializerFactory;
    }
    
    /**
     * @return Returns the sessionManager.
     */
    public SessionManager getSessionManager() {
        return sessionManager;
    }

}
