/*
 * $RCSfile: DefaultWsInvocationReceiver.java,v $
 * $Date: 2007/06/09 02:33:10 $
 * $Revision: 1.9 $
 * $Author: xblanc $
 */

/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * DefaultWsInvocationReceiver.java 
 * 
 * @author Prawee Sriplakich, Andrey Sadovykh (LIP6)
 * @version $Revision: 1.9 $ $Date: 2007/06/09 02:33:10 $
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws;

import java.util.List;
import java.util.Map;
import java.util.logging.Level;

import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;

import org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.DescriptionUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.ModelSerializerFactory;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.Repository;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.RepositoryClient;
import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;
import org.eclipse.mddi.modelbus.adapter.user.InvalidSession;
import org.eclipse.mddi.modelbus.adapter.user.ModelingServiceError;
import org.eclipse.mddi.modelbus.adapter.user.SessionNeeded;
import org.eclipse.mddi.modelbus.adapter.user.provider.GenericProvider;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingService;
import org.eclipse.mddi.modelbus.description.abstract_.Parameter;

public class DefaultWsInvocationReceiver extends WsInvocationReceiver {
    AdapterStub adapter;

    SOAPEnvelope reqMsg;

    SOAPEnvelope resMsg;

    ModelingService ms;

    // in/inout parameter values
    Map inputs;

    // out/inout parameter values
    Map outputs;



    public DefaultWsInvocationReceiver(AdapterStub adapter) {

        this.adapter = adapter;
        setMarshaler(new DefaultMarshaler());
        
        Repository client = new RepositoryClient(adapter.getGenericConsumer());
        getMarshaler().setRepositoryClient(client);
        
        
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.mddi.modelbus.adapter.user.provider.WsInvocationReceiver#process(javax.xml.soap.SOAPMessage,
     *      javax.xml.soap.SOAPMessage)
     */
    public void process(SOAPEnvelope reqMsg, SOAPEnvelope resMsg) {
        this.reqMsg = reqMsg;
        this.resMsg = resMsg;
        try {
            readRequest();
            performService();
            createResponse();
            
        } catch (Exception e) {
            try {
                createSoapFault(resMsg, e);
            } catch (SOAPException e1) {
                // TODO Auto-generated catch block
                e1.printStackTrace();
            }
            // org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger.getLogger().log(Level.INFO,resMsg,e);  // debug info will be showned in createSoapFault(...)
        }
    }

    /**
     * Reads the content in the HTTP request
     * 
     * @throws Exception
     */
    public void readRequest() throws Exception {

        SOAPBody requestbody = reqMsg.getBody();
        // the first child in the SOAP body is a input message conforming to
        // WSDL
        SOAPElement reqTopElem = SoapUtil.getFirstChild(requestbody);
        if (reqTopElem == null) {
             org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger.getLogger().log(Level.SEVERE, "SERVER: received empty request");
             org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger.getLogger().log(Level.INFO, reqMsg.toString());
            throw new SOAPException("Empty SOAP request");
        }
        
        // set the model serializer factory corresponding 
        // to the encoding of the message
        ModelSerializerFactory f = adapter.getTransportManager().findModelSerializerFactory(
                reqTopElem.getAttribute(DefaultMarshaler.MODEL_SERIALIZER_PROP));
        getMarshaler().setModelSerializerFactory(f);

        String serviceName = reqTopElem.getLocalName();

        ms = DescriptionUtil.getServiceDescription(serviceName, adapter
                .getToolDescription());
        if (ms == null) {
            throw new SOAPException("Service unknown - " + serviceName);
        }

        List<Parameter> params = DescriptionUtil.get_in_inout_Parameters(ms);

        inputs = marshaler.unmarshal(params, reqTopElem);
    }

    public void performService() throws SessionNeeded, ModelingServiceError,
            InvalidSession {
        GenericProvider si = adapter.getToolStub().getProvider();
        String serviceName = ms.getName();
        if(adapter.getToolStub().getProvider()!=null) {            
            Parameter[] inputParams = (Parameter[]) DescriptionUtil.get_in_inout_Parameters(ms).toArray(new Parameter[0]);
            Parameter[] outputParams = (Parameter[]) DescriptionUtil.get_out_inout_Parameters(ms).toArray(new Parameter[0]);
            Object[] inputArray, outputArray;
            inputArray = DescriptionUtil.map2Array(inputParams, inputs);
            outputArray = adapter.getToolStub().getProvider().execute(serviceName, inputArray);
            outputs = DescriptionUtil.array2Map(outputParams, outputArray);
            
        } else if(adapter.getToolStub().getProvider2()!=null) {
            outputs = adapter.getToolStub().getProvider2().execute(serviceName, inputs);
        } else {
             org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger.getLogger().log(Level.SEVERE, "No Provider object found for tool " + adapter.getToolDescription());
            throw new ModelingServiceError("Config problem", 
                    "No tool impl for " + adapter.getToolDescription());
        }
    }

    /**
     * Produces the HTTP response
     * 
     * @throws Exception
     */
    public void createResponse() throws Exception {
        SOAPBody responsebody = resMsg.getBody();
        DefaultMarshaler.setNamespaces(responsebody);

        SOAPElement resTopElem = responsebody.addChildElement(ms.getName()
                + "Response", "modelbus");
        
        List<Parameter> params = DescriptionUtil.get_out_inout_Parameters(ms);
        
        marshaler.marshal(params, outputs, resTopElem);
    }
    




    /**
     * Creates a SOAP fault from a cause exception
     * 
     * @param resMsg
     * @param cause
     * @throws SOAPException
     *             if the SOAP fault cannot be created
     */
    public void createSoapFault(SOAPEnvelope resMsg, Exception cause)
            throws SOAPException {
        SOAPBody responsebody = resMsg.getBody();
        DefaultMarshaler.setNamespaces(responsebody);

        SOAPFault f = responsebody.addFault();
        ModelingServiceError err;
        if (cause instanceof ModelingServiceError) {
            RootLogger.getLogger().log(Level.INFO, "Creating Soap fault for ModelingServiceError " +cause.getMessage());
            err = (ModelingServiceError) cause;
        } else {
            RootLogger.getLogger().log(Level.SEVERE, "Creating Soap fault for runtime exception ", cause);
            err = new ModelingServiceError("Runtime error at Server ", cause.toString());
        } 
        marshaler.marshalModelingServiceError(err, f);
    }
    
    public static void createSimpleSoapFault(SOAPEnvelope resMsg, Exception cause)
    throws SOAPException{
        SOAPBody responsebody = resMsg.getBody();
        DefaultMarshaler.setNamespaces(responsebody);
        SOAPFault f = responsebody.addFault();
        f.setFaultString(cause.getClass() + ":" + cause.getMessage());
         org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger.getLogger().log(Level.SEVERE, "Error", cause);
      
    }

    /**
     * Creates a SOAP fault from an error message
     * 
     * @param resMsg
     * @param errorMessage
     * @throws SOAPException
     *             if the SOAP fault cannot be created
     */
    public static void createSoapFault(SOAPEnvelope resMsg, String errMessage)
            throws SOAPException {
        SOAPBody responsebody = resMsg.getBody();
        DefaultMarshaler.setNamespaces(responsebody);
        SOAPFault f = responsebody.addFault();
        f.setFaultCode("modelbus:ServerError");
        f.setFaultString(errMessage);
         org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger.getLogger().log(Level.SEVERE, "modelbus:ServerError. " + errMessage);
    }

}
