/*
 * $RCSfile: EndPointManagerImpl.java,v $ $Date: 2007/04/19 00:44:20 $
 * $Revision: 1.3 $ $Author: xblanc $
 */

/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus. All rights
 * reserved.
 * 
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * EndPointManagerImpl.java
 * 
 * @author Prawee Sriplakich
 * 
 * @version $Revision: 1.3 $ $Date: 2007/04/19 00:44:20 $
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;

import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;

public class EndPointManagerImpl implements EndPointManager {


    private static EndPointManager endPointManager = new EndPointManagerImpl();

    public static EndPointManager getInstance() {
        return endPointManager;
    }

    Map endPointMap = new Hashtable(); //stores endpoints according to
                                       // incomplete relative path

    public EndPoint getEndPoint(String relativePath) {
        for (Iterator it = endPointMap.keySet().iterator(); it.hasNext();) {
            String incompleteRelativePath = (String) it.next();
            if (relativePath.startsWith(incompleteRelativePath)) {
                return (EndPoint) endPointMap.get(incompleteRelativePath);
            }
        }
        return null;
    }

    public void putEndPoint(String incompleteRelativePath, EndPoint endPoint) {
        endPointMap.put(incompleteRelativePath, endPoint);
         org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger.getLogger().log(Level.INFO,"add path:"+incompleteRelativePath);
    }

    public void execute(String urlPath, SOAPEnvelope req, SOAPEnvelope resp) {
        EndPoint ep = getEndPoint(urlPath);
        if (ep != null) {
            try {
                ep.execute(urlPath, req, resp);
            } catch (SOAPException e) {
                e.printStackTrace();
            }
        } else {
             org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger.getLogger().log(Level.INFO,"No EndPoint for url : " + urlPath);

        }
    }

    /* (non-Javadoc)
     * @see org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.EndPointManager#removeEndPoint(java.lang.String)
     */
    public void removeEndPoint(String incompleteRelativePath) {
        endPointMap.remove(incompleteRelativePath);
         org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger.getLogger().log(Level.INFO,"Endpoint removed : path= "+incompleteRelativePath);
    }
}
