/*
 * $RCSfile: Marshaler.java,v $
 * $Date: 2007/06/09 02:33:10 $
 * $Revision: 1.6 $
 * $Author: xblanc $
 */

/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * ParameterMarshaler.java Add description 
 * 
 * @author Prawee Sriplakich, Andrey Sadovykh (LIP6)
 * @version $Revision: 1.6 $ $Date: 2007/06/09 02:33:10 $
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws;


import java.util.List;
import java.util.Map;

import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;

import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.ModelSerializer;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.ModelSerializerFactory;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.Repository;
import org.eclipse.mddi.modelbus.adapter.user.ModelingServiceError;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelBusCommunicationException;
import org.eclipse.mddi.modelbus.description.abstract_.Error;
import org.eclipse.mddi.modelbus.description.abstract_.Parameter;

public interface Marshaler {



    /**
     * 
     * marshal all parameter values to the specified top element
     * 
     * @param params an array of patameter definitions to marshall
     * @param parameterValues Map of parameter names and parameter values
     * @param topElem the SOAPElement from which the value of the parameter will be extracted.
     * Its tag name is the service name
     * @throws Exception
     * 
     *
     */
    public void marshal(List<Parameter> params, Map<String, Object> parameterValues,
            SOAPElement topElem) throws SOAPException, ModelBusCommunicationException;

    /**
     * 
     * unmarshal all parameter values to specified the top element
     * 
     * @param params an array of patameter definitions to marshall
     * @param topElem topElem the SOAPElement from which the value of the parameter will be extracted.
     * Its tag name is the service name
     * @return
     * @throws Exception
     * 
     *
     */
    public Map<String, Object> unmarshal(List<Parameter> params, SOAPElement topElem) throws SOAPException, 
                ModelBusCommunicationException;
    
   

    public ModelSerializer getModelSerializer();
    
    public void setModelSerializerFactory(ModelSerializerFactory f);
    
    public void marshalModelingServiceError(ModelingServiceError err,
            SOAPFault f) throws SOAPException;
    
 
    public ModelingServiceError unmarshalModelingServiceError(Error errorType,SOAPFault f) throws SOAPException;

    /**
     * used for passing models by references
     */
    public Repository getRepositoryClient();

    /**
     * used for passing models by references
     */
    public void setRepositoryClient(Repository repositoryClient);
    
}