/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * Created on 15 juin 2005
 *
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws;

import java.util.Iterator;

import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;


/**
 * @author Prawee Sriplakich, Nicolas Garandeau (LIP6)
 * 
 *  
 */
public class SoapUtil {

    public static SOAPConnectionFactory connectionFactory;


    static {
        try {
            connectionFactory = SOAPConnectionFactory.newInstance();
        } catch (UnsupportedOperationException e) {
            e.printStackTrace();
        } catch (SOAPException e) {
            e.printStackTrace();
        }

    }

    public static MessageFactory messageFactory = new org.apache.axis.soap.MessageFactoryImpl();

    public static SOAPElement getChildByLocalName(SOAPElement elem,
            String localName) {
        Iterator it = elem.getChildElements();
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof SOAPElement) {
                SOAPElement child = (SOAPElement) o;
                if (child.getLocalName().equals(localName)) {
                    return child;
                }
            }
        }
        return null;
    }

    public static SOAPElement getChildByFullName(SOAPElement elem, String name) {
        Iterator it = elem.getChildElements();
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof SOAPElement) {
                SOAPElement child = (SOAPElement) o;
                if (child.getNodeName().equals(name)) {
                    return child;
                }
            }
        }
        return null;
    }

    public static SOAPElement getFirstChild(SOAPElement elem) {
        SOAPElement child = null;
        Iterator it = elem.getChildElements();
        while (it.hasNext() && child == null) {
            Object o = it.next();
            if (o instanceof SOAPElement) {
                child = (SOAPElement) o;
            }
        }
        return child;
    }

    //    public static String getTextNodeValue(SOAPElement elem) {
    //      	Text child = null;
    //      	Iterator it = elem.getChildElements();
    //      	while(it.hasNext() && child == null) {
    //      	  Object o = it.next();
    //      	  if(o instanceof Text) {
    //      	    child = (Text) o;
    //      	  }
    //      	}
    //      	return child.getValue();
    //    }
}
