/*
 * $RCSfile: TransportManager.java,v $
 * $Date: 2007/06/07 13:33:39 $
 * $Revision: 1.6 $
 * $Author: xblanc $
 */
 
/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */
 
/*
 * Transport.java Add description 
 * 
 * @author Prawee Sriplakich
 * @version $Revision: 1.6 $ $Date: 2007/06/07 13:33:39 $
 * @see Add references
 *
 * TODO Add description
 * TODO Add references
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws;

import java.net.URL;
import java.util.List;

import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.ModelSerializerFactory;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ProviderProxy;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.SessionManager;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.SessionProviderProxy;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelBusCommunicationException;
import org.eclipse.mddi.modelbus.description.concrete.Tool;

public interface TransportManager {

    public ProviderProxy createProviderProxy(URL url);
    
    public ProviderProxy createProviderProxy(Tool t) throws ModelBusCommunicationException;
    
    public SessionProviderProxy createSessionProviderProxy(Tool t) throws ModelBusCommunicationException;

    public WsInvocationReceiver createWsInvocationReceiver();

    /**
     * Set the model serializer factory to be used by default
     */
    public void setDefaultModelSerializerFactory(ModelSerializerFactory f);
    
    /**
     * Get the list of all installed model serializers
     * @return
     */
    public List getModelSerializerFactoryList();
    
    
    /**
     * get the model serializer factory with the specified name.
     * If the specified factory is not found, 
     * then return the default one.
     * @return
     */
    public ModelSerializerFactory findModelSerializerFactory(String name);
    

    public SessionManager getSessionManager();
    
}
