/*
 * Created on 16 juin 2006
 *
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.async;

import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;





/**
 * @author Nicolas Garandeau (lip6)
 *
 */
public abstract class SOAPAsyncConnection{
	
	public SOAPAsyncConnection() {}
	
    /**
     * Sends the given message to the specified endpoint in a non-blocking way.
     * The result will be registered in an object that we can poll with 
     * isResultReady() and getResult() methods.
     * @param request the <CODE>SOAPMessage</CODE>
     *     object to be sent
     * @param endpoint an <code>Object</code> that identifies
     *            where the message should be sent. It is required to
     *            support Objects of type
     *            <code>java.lang.String</code>,
     *            <code>java.net.URL</code>, and when JAXM is present
     *            <code>javax.xml.messaging.URLEndpoint</code>
     * @param pool the <CODE>ThreadPoolQueue</CODE> object in which we execute the call task
     * @return the <CODE>SOAPMessage</CODE> object that is the
     *     response to the message that was sent
     * @throws  SOAPException if there is a SOAP error
     */
	public abstract String call(SOAPMessage request, Object endpoint,ThreadPoolQueue pool) throws SOAPException;

	 /**
     * To get the information if the result is ready or not
     * @return the boolean that indicates if the result is ready
     */
	public abstract boolean isResultReady();
	
	 /**
     * To get the result if the result is ready
     * @return the result object if the result is ready
     * @throws  ResultNotReadyException if the result is not yet ready
     */
	public abstract Object getResult() throws ResultNotReadyException;
	
    /**
     * Closes this <CODE>SOAPAsyncConnection</CODE> object.
     * @throws  SOAPException if there is a SOAP error
     */
	public abstract void close() throws SOAPException;

}
