/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * Created on 24 mai 2005
 *
 */
package org.eclipse.mddi.modelbus.adapter.user;

import org.eclipse.mddi.modelbus.adapter.user.notification.NotificationConsumer;
import org.eclipse.mddi.modelbus.adapter.user.provider.GenericProvider;
import org.eclipse.mddi.modelbus.adapter.user.provider.GenericProvider2;
import org.eclipse.mddi.modelbus.adapter.user.provider.GenericSessionProvider;

/**
 * This class represents the Tool component. It provides operations for
 * obtainning the interfaces offerred by the component.
 * 
 * @author Prawee Sriplakich (LIP6)
 * 
 *  
 */
public interface ToolStub {

    /**
     * @deprecated Sets an object that executes sessionless Modeling Services.
     * @param si
     *            object that executes sessionless Modeling Services.
     */
    public void setServiceInvocation(GenericProvider si);

    /**
     * Sets an object that executes sessionless Modeling Services.
     * 
     * @depricated use setProvider2
     * @param provider
     *            object that executes sessionless Modeling Services.
     */
    public void setProvider(GenericProvider provider);

    
    /**
     * Sets an object that executes sessionless Modeling Services.
     * 
     * @param provider
     *            object that executes sessionless Modeling Services.
     */
    public void setProvider2(GenericProvider2 provider);
    
    /**
     * @deprecated Obtains an object that executes sessionless Modeling
     *             Services.
     * @return object that executes sessionless Modeling Services.
     */
    public GenericProvider getServiceInvocation();

    /**
     * Obtains an object that executes sessionless Modeling Services.
     * 
     * @return object that executes sessionless Modeling Services.
     */
    public GenericProvider getProvider();
    
    /**
     * Obtains an object that executes sessionless Modeling Services.
     * 
     * @return object that executes sessionless Modeling Services.
     */
    public GenericProvider2 getProvider2();    

    /**
     * @deprecated Sets an object that executes sessionful Modeling Services.
     * @param si
     *            object that executes sessionful Modeling Services.
     */
    public void setSessionServiceInvocation(GenericSessionProvider si);

    /**
     * Sets an object that executes sessionful Modeling Services.
     * 
     * @param sessionProvider
     *            object that executes sessionful Modeling Services.
     */
    public void setSessionProvider(GenericSessionProvider sessionProvider);

    /**
     * Obtains an object that executes sessionful Modeling Services.
     * @return object that executes sessionful Modeling Services.
     * @deprecated use getSessionProvider() instead
     */
    public GenericSessionProvider getSessionServiceInvocation();

    /**
     * Obtains an object that executes sessionful Modeling Services.
     * 
     * @return object that executes sessionful Modeling Services.
     */
    public GenericSessionProvider getSessionProvider();

    //////////////////////////////////// notification-related part

    /**
     * Sets object for receiving the notification from the Adapter.
     * 
     * @param nc
     *            An object implementing the NotificationConsumer interface. On
     *            notification, this object will perform the action according to
     *            the Tool-specific logic.
     *  
     */
    public void setNotificationConsumer(NotificationConsumer nc);

    /**
     * Gets object that is reponsible for processing notifications.
     * 
     * @return An object implementing the NotificationConsumer interface.
     */
    public NotificationConsumer getNotificationConsumer();

}
