/*
 * $RCSfile: Notification.java,v $
 * $Date: 2006/03/13 16:13:23 $
 * $Revision: 1.2 $
 * $Author: xblanc $
 */
 
/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */
 
/*
 * Notification.java Add description 
 * 
 * @author Prawee Sriplakich (LIP6)
 * @version $Revision: 1.2 $ $Date: 2006/03/13 16:13:23 $
 * @see Add references
 *
 * TODO Add description
 * TODO Add references
 */
package org.eclipse.mddi.modelbus.adapter.user.notification;

import org.eclipse.mddi.modelbus.adapter.infrastructure.notification.SerializedNotification;

/**
 * This class represents the notification information.
 * Its added-value is that it is dedicated to models 
 * (the notification can contan models).
 * 
 * @author P. Sriplakich
 *
 *
 */
public class Notification {
    
    public Notification(SerializedNotification serialized) {
        name = serialized.topic;
        
        //TODO the info can be models!! or other things (boolean etc)
        // So we need to deserialized if needed
        info = serialized.message;
    }
    
    
    public Notification(String _name, Object _info) {
        name = _name;
        info = _info;
    }
    
    
    /**
     * The name of the notification.
     * @see org.eclipse.mddi.modelbus.description.abstract_.Error
     */
    String name;
    
    /**
     * @return Returns the name.
     */
    public String getName() {
        return name;
    }
    /**
     * @param name The name to set.
     */
    public void setName(String name) {
        this.name = name;
    }
    
    /**
     * The information contained by the notification.
     * This information can be either primitive data or model.
     * Its type must correspond to the error type defined in the tool description.
     * 
     * @see org.eclipse.mddi.modelbus.description.abstract_.Event
     */    
    Object info;
    
    
    
    
    /**
     * @return Returns the info.
     */
    public Object getInfo() {
        return info;
    }
    /**
     * @param info The info to set.
     */
    public void setInfo(Object info) {
        this.info = info;
    }
    

}
