/*
 * $RCSfile: GenericProvider2.java,v $
 * $Date: 2006/10/10 09:08:26 $
 * $Revision: 1.1 $
 * $Author: xblanc $
 */
 
/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */
 
/*
 * GenericProvider2.java Add description 
 * 
 * @author Prawee Sriplakich
 * @version $Revision: 1.1 $ $Date: 2006/10/10 09:08:26 $
 * @see Add references
 *
 * TODO Add description
 * TODO Add references
 */
package org.eclipse.mddi.modelbus.adapter.user.provider;

import java.util.Map;

import org.eclipse.mddi.modelbus.adapter.user.ModelingServiceError;
import org.eclipse.mddi.modelbus.adapter.user.SessionNeeded;

/**
 * 
 * This interface is similar to GenericProvider 
 * but it uses Maps instead of Arrays for passing parameters
 * <p>
 * If the tool integrator implements this interface, 
 * then he can connect his implementation with the ToolStub via the method 
 * ToolStub.setGenericProvider2()  
 * 
 * 
 * @author Prawee Sriplakich (LIP6)
 *
 *
 */
public interface GenericProvider2 {

    /**
     * Asks the provider tool to perform the specified Modeling Service in the sessionless style. 
     * The parameter values are represented as Java objects according 
     * to the same mappings as defined in 
     * <code>org.eclipse.mddi.modelbus.adapter.GenericServiceInvocation</code> 
     * <p>
     * This operation is similar to one of GenericProvider 
     * but it uses Maps instead of Arrays for passing parameters
     * 
     * @param serviceName
     * @param parameterValues
     * @return
     * @throws SessionNeeded
     * @throws ModelingServiceError an error that is produced by the provider tools during service execution.
     */
    Map execute(String serviceName, Map parameterValues) throws SessionNeeded, ModelingServiceError;  
    
}
