/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation;

import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.QualifiedServiceName;
import org.eclipse.mddi.modelbus.description.abstract_.AbstractFactory;
import org.eclipse.mddi.modelbus.description.abstract_.DirectionKind;
import org.eclipse.mddi.modelbus.description.abstract_.Error;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingService;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingServiceInterface;
import org.eclipse.mddi.modelbus.description.abstract_.Parameter;
import org.eclipse.mddi.modelbus.description.abstract_.impl.AbstractPackageImpl;
import org.eclipse.mddi.modelbus.description.concrete.ConcreteFactory;
import org.eclipse.mddi.modelbus.description.concrete.Property;
import org.eclipse.mddi.modelbus.description.concrete.Tool;
import org.eclipse.mddi.modelbus.description.concrete.impl.ConcretePackageImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescriptionUtil {
    public static final String IS_SESSION_ENABLED = "IsSessionEnabled";
    public static final AbstractFactory abstractFactory = AbstractPackageImpl.init().getAbstractFactory();
    public static final ConcreteFactory concreteFactory = ConcretePackageImpl.init().getConcreteFactory();

    public static ModelingService getServiceDescription(String serviceName, Tool t) {
        QualifiedServiceName qname = QualifiedServiceName.getQualifiedServiceName(serviceName);
        for (ModelingService s : t.getInterface().getService()) {
            if (!qname.serviceName.equals(s.getName())) continue;
            return s;
        }
        return null;
    }

    public static boolean isToolEqual(Tool t1, Tool t2) {
        if (t1.getName().equals(t2.getName()) && t1.getInterface().getName().equals(t2.getInterface().getName())) {
            for (ModelingService testService : t1.getInterface().getService()) {
                ModelingService matchingService = DescriptionUtil.getServiceDescription(testService.getName(), t2);
                if (matchingService != null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static String getFullServiceName(ModelingService s) {
        ModelingServiceInterface intf = (ModelingServiceInterface)s.eContainer();
        if (intf != null) {
            return String.valueOf(intf.getName()) + "." + s.getName();
        }
        return s.getName();
    }

    public static List<Parameter> get_in_inout_Parameters(ModelingService ms) {
        DirectionKind[] dk = new DirectionKind[]{DirectionKind.IN_LITERAL, DirectionKind.INOUT_LITERAL};
        return DescriptionUtil.getParameters(ms, dk);
    }

    public static List<Parameter> get_out_inout_Parameters(ModelingService ms) {
        DirectionKind[] dk = new DirectionKind[]{DirectionKind.OUT_LITERAL, DirectionKind.RETURN_LITERAL, DirectionKind.INOUT_LITERAL};
        return DescriptionUtil.getParameters(ms, dk);
    }

    public static List<Parameter> getInParameters(ModelingService ms) {
        DirectionKind[] dk = new DirectionKind[]{DirectionKind.IN_LITERAL};
        return DescriptionUtil.getParameters(ms, dk);
    }

    public static List<Parameter> getOutParameters(ModelingService ms) {
        DirectionKind[] dk = new DirectionKind[]{DirectionKind.OUT_LITERAL};
        return DescriptionUtil.getParameters(ms, dk);
    }

    public static List<Parameter> getInoutParameters(ModelingService ms) {
        DirectionKind[] dk = new DirectionKind[]{DirectionKind.INOUT_LITERAL};
        return DescriptionUtil.getParameters(ms, dk);
    }

    public static List<Parameter> getParameters(ModelingService ms, DirectionKind[] dk) {
        Vector<Parameter> result = new Vector<Parameter>();
        for (Parameter p : ms.getParameter()) {
            int i = 0;
            while (i < dk.length) {
                if (p.getDirection().equals(dk[i])) {
                    result.add(p);
                }
                ++i;
            }
        }
        return result;
    }

    public static Error getError(ModelingService ms, String errorName) {
        for (Error error : ms.getServiceError()) {
            if (!error.getName().equals(errorName)) continue;
            return error;
        }
        return null;
    }

    public static Parameter getParameter(ModelingService ms, String paramName) {
        for (Parameter p : ms.getParameter()) {
            if (!paramName.equals(p.getName())) continue;
            return p;
        }
        return null;
    }

    public static Object[] map2Array(Parameter[] params, Map<String, Object> values) {
        Object[] result = new Object[params.length];
        int i = 0;
        while (i < params.length) {
            result[i] = values.get(params[i].getName());
            ++i;
        }
        return result;
    }

    public static Map<String, Object> array2Map(Parameter[] params, Object[] values) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        int i = 0;
        while (i < params.length) {
            result.put(params[i].getName(), values[i]);
            ++i;
        }
        return result;
    }

    public static String getParameterNameList(Parameter[] params) {
        String result = null;
        int i = 0;
        while (i < params.length) {
            Parameter p = params[i];
            result = result == null ? p.getName() : String.valueOf(result) + ", " + p.getName();
            ++i;
        }
        return result;
    }

    public static String getProperty(Tool t, String propertyName) {
        for (Property p : t.getProperty()) {
            String proName = p.getName();
            if (proName == null || !proName.equalsIgnoreCase(propertyName)) continue;
            return p.getValue();
        }
        return null;
    }

    public static Property getPropertyObject(Tool t, String propertyName) {
        for (Property p : t.getProperty()) {
            if (!p.getName().equalsIgnoreCase(propertyName)) continue;
            return p;
        }
        return null;
    }

    public static String getUrl(Tool t) {
        Property p = DescriptionUtil.getPropertyObject(t, "URL");
        if (p == null) {
            return null;
        }
        return p.getValue();
    }

    public static boolean getIsSessionEnabled(Tool t) {
        String pro = DescriptionUtil.getProperty(t, IS_SESSION_ENABLED);
        if (pro == null) {
            return false;
        }
        return pro.startsWith("true");
    }

    public static void importAllMetamodels(Tool t, Collection ignoredUriPrefixSet) {
        Resource r = t.eResource();
        HashSet<Resource> s = new HashSet<Resource>();
        s.add(r);
        ModelUtil.addCrossReferencedResources(s, ignoredUriPrefixSet);
        for (Resource r2 : s) {
            if (r2 == r) continue;
            r.getContents().addAll((Collection)r2.getContents());
        }
    }
}

