/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelBusResourceSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelUtil {
    public static Collection findElementByType(Collection emfobjs, String typeName) {
        HashSet<EObject> set = new HashSet<EObject>();
        for (EObject o : emfobjs) {
            if (!o.eClass().getName().equals(typeName)) continue;
            set.add(o);
        }
        return set;
    }

    public static Collection findElementByType_considerSubtypes(Collection emfobjs, EClass type) {
        HashSet<EObject> set = new HashSet<EObject>();
        for (EObject o : emfobjs) {
            if (!ModelUtil.isInstanceOf(o, type)) continue;
            set.add(o);
        }
        return set;
    }

    public static boolean isInstanceOf(EObject o, EClass c) {
        EClass subc = o.eClass();
        if (subc.equals(c)) {
            return true;
        }
        return subc.getEAllSuperTypes().contains((Object)c);
    }

    public static EObject findElementByName(Collection model, String name) {
        for (EObject o : model) {
            Object _name;
            EStructuralFeature f = o.eClass().getEStructuralFeature("name");
            if (f == null || (_name = o.eGet(f, false)) == null || !_name.equals(name)) continue;
            return o;
        }
        return null;
    }

    public static EStructuralFeature findStructuralFeature(EClass c, String featureName) {
        EStructuralFeature f2 = null;
        for (EStructuralFeature f2 : c.getEAllStructuralFeatures()) {
            if (!f2.getName().equals(featureName)) continue;
            return f2;
        }
        return null;
    }

    public static List flattenHirachicalCollection(Collection eObjects) {
        Vector<EObject> target = new Vector<EObject>();
        for (EObject o : eObjects) {
            target.add(o);
            TreeIterator it2 = o.eAllContents();
            while (it2.hasNext()) {
                EObject o2 = (EObject)it2.next();
                target.add(o2);
            }
        }
        return target;
    }

    public static Collection getTopElementsFromResources(Resource[] resources) {
        Vector result = new Vector();
        int i = 0;
        while (i < resources.length) {
            Resource r = resources[i];
            result.addAll(r.getContents());
            ++i;
        }
        return result;
    }

    public static Collection getTopElements(Collection model) {
        HashSet<EObject> target = new HashSet<EObject>();
        for (EObject o : model) {
            EObject topElem = ModelUtil.getTopElement(o);
            if (target.contains(topElem)) continue;
            target.add(topElem);
        }
        return target;
    }

    public static EObject getTopElement(EObject o) {
        EObject topElem = o;
        while (topElem.eContainer() != null) {
            topElem = topElem.eContainer();
        }
        return topElem;
    }

    public static boolean isEObjectCollection(Collection c) {
        for (Object o : c) {
            if (o instanceof EObject) continue;
            return false;
        }
        return true;
    }

    public static Object getFeatureValue(EObject o, String featureName) {
        EStructuralFeature f = o.eClass().getEStructuralFeature(featureName);
        if (f == null) {
            return null;
        }
        return o.eGet(f, false);
    }

    public static Object createFromString(String primitiveType, String value) {
        if (primitiveType.equalsIgnoreCase("string")) {
            return value;
        }
        if (primitiveType.equalsIgnoreCase("boolean")) {
            return Boolean.valueOf(value);
        }
        if (primitiveType.equalsIgnoreCase("integer")) {
            return new Integer(Integer.parseInt(value));
        }
        if (primitiveType.equalsIgnoreCase("double")) {
            return new Double(Double.parseDouble(value));
        }
        System.err.println("unknown primitive " + primitiveType);
        return null;
    }

    public static Collection getTopElemsInFragment(Collection fragment) {
        HashSet<EObject> result = new HashSet<EObject>();
        Iterator it = fragment.iterator();
        while (it.hasNext()) {
            EObject e = ModelUtil.getTopElemInFragment((EObject)it.next(), fragment);
            result.add(e);
        }
        return result;
    }

    public static EObject getTopElemInFragment(EObject currentElem, Collection fragment) {
        EObject topElem = currentElem;
        while (topElem.eContainer() != null && fragment.contains(topElem.eContainer())) {
            topElem = topElem.eContainer();
        }
        return topElem;
    }

    public static Adapter findAdapter(Notifier target, Object type) {
        for (Adapter adapter : target.eAdapters()) {
            if (!adapter.isAdapterForType(type)) continue;
            return adapter;
        }
        return null;
    }

    public static void addCrossReferencedResources(Set resources, Collection ignoredUriPrefixSet) {
        Vector<Object> queue = new Vector<Object>();
        for (Resource r : resources) {
            TreeIterator it2 = r.getAllContents();
            while (it2.hasNext()) {
                EObject containedObject = (EObject)it2.next();
                queue.add(containedObject);
            }
        }
        while (!queue.isEmpty()) {
            EObject o = (EObject)queue.remove(0);
            for (EObject referencedObject : o.eCrossReferences()) {
                if (referencedObject instanceof EFactory || referencedObject.eIsProxy()) continue;
                Resource cr = referencedObject.eResource();
                if (cr != null && !resources.contains(cr)) {
                    if (ModelUtil.uriBeginsWith(cr.getURI(), ignoredUriPrefixSet)) continue;
                    resources.add(cr);
                    TreeIterator it2 = cr.getAllContents();
                    while (it2.hasNext()) {
                        queue.add(it2.next());
                    }
                    continue;
                }
                if (cr != null) continue;
                cr = ModelUtil.findOrCreateDefaultResource(resources);
                EObject top = ModelUtil.getTopElement(referencedObject);
                cr.getContents().add((Object)top);
                resources.add(cr);
                TreeIterator it2 = top.eAllContents();
                while (it2.hasNext()) {
                    queue.add(it2.next());
                }
            }
        }
    }

    public static List<Resource> getResourcesFromObjects(Collection emfobjs, boolean skipCrossReferences, Collection ignoredUriPrefixSet) {
        HashSet<Resource> resources = new HashSet<Resource>();
        HashSet<EObject> orphanTopElements = new HashSet<EObject>();
        for (EObject o : emfobjs) {
            Resource r = o.eResource();
            if (r == null) {
                EObject top = ModelUtil.getTopElement(o);
                orphanTopElements.add(top);
                continue;
            }
            resources.add(r);
        }
        if (!orphanTopElements.isEmpty()) {
            Resource defaultResource = ModelUtil.findOrCreateDefaultResource(resources);
            defaultResource.getContents().addAll(orphanTopElements);
            resources.add(defaultResource);
        }
        if (!skipCrossReferences) {
            ModelUtil.addCrossReferencedResources(resources, ignoredUriPrefixSet);
        }
        return new Vector<Resource>(resources);
    }

    private static Resource findOrCreateDefaultResource(Collection resources) {
        for (Resource r : resources) {
            if (!ModelBusResourceSet.MB_DEFAULT_RES_URI.equals((Object)r.getURI())) continue;
            return r;
        }
        ModelBusResourceSet rSet = new ModelBusResourceSet();
        Resource defaultResource = rSet.createResource(ModelBusResourceSet.MB_DEFAULT_RES_URI);
        return defaultResource;
    }

    public static void ensureContainment(ResourceSet rs) {
        int i = 0;
        while (i < rs.getResources().size()) {
            Resource r = (Resource)rs.getResources().get(i);
            ModelUtil.ensureContainment(r);
            ++i;
        }
    }

    public static void ensureContainment(Resource r) {
        int j = 0;
        while (j < r.getContents().size()) {
            EObject o = (EObject)r.getContents().get(j);
            ModelUtil.ensureContainmentForAll(r, o);
            ++j;
        }
    }

    private static void ensureContainmentForAll(Resource r, EObject o) {
        ModelUtil.ensureContainmentInternal(r, o);
        TreeIterator it = o.eAllContents();
        while (it.hasNext()) {
            EObject child = (EObject)it.next();
            ModelUtil.ensureContainmentInternal(r, child);
        }
    }

    private static void ensureContainmentInternal(Resource r, EObject o) {
        EContentsEList.FeatureIterator featureIterator = (EContentsEList.FeatureIterator)o.eCrossReferences().iterator();
        while (featureIterator.hasNext()) {
            InternalEObject target = (InternalEObject)featureIterator.next();
            EReference eReference = (EReference)featureIterator.feature();
            if (target.eIsProxy() || eReference.isDerived() || eReference.isTransient() || target.eResource() != null) continue;
            EObject top = ModelUtil.getTopElement((EObject)target);
            r.getContents().add((Object)top);
            RootLogger.getLogger().log(Level.INFO, "ensureContainment: add " + ModelUtil.getTypeAndNameLabel(top) + " to " + r.getURI());
        }
    }

    public static boolean uriBeginsWith(URI uri, Collection prefixSet) {
        if (prefixSet == null) {
            return false;
        }
        String uriString = uri.toString();
        for (String prefix : prefixSet) {
            if (!uriString.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsURI(ResourceSet rs, URI uri) {
        int i = 0;
        while (i < rs.getResources().size()) {
            Resource r = (Resource)rs.getResources().get(i);
            if (r.getURI().equals((Object)uri)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String getTypeAndNameLabel(EObject o) {
        if (o == null) {
            return "null";
        }
        EStructuralFeature f = o.eClass().getEStructuralFeature("name");
        if (f instanceof EAttribute) {
            return String.valueOf(o.eClass().getName()) + "_" + o.eGet(f, false);
        }
        return o.eClass().getName();
    }

    public static boolean isRegistered(EPackage p) {
        return EPackage.Registry.INSTANCE.containsValue((Object)p);
    }

    public static void registerEPackage(EPackage p) {
        EPackage registered;
        String uri = p.getNsURI();
        if (uri == null || "".equals(uri)) {
            EPackage superp = p.getESuperPackage();
            uri = superp == null ? "http://model/" + p.getName() : String.valueOf(superp.getNsURI()) + "/" + p.getName();
            p.setNsURI(uri);
        }
        if ((registered = EPackage.Registry.INSTANCE.getEPackage(p.getNsURI())) != null && registered != p) {
            RootLogger.getLogger().log(Level.WARNING, "The EPackage for NS URI " + p.getNsURI() + " changed: " + registered + " -> " + p);
        }
        EPackage.Registry.INSTANCE.put((Object)p.getNsURI(), (Object)p);
        for (EPackage subp : p.getESubpackages()) {
            ModelUtil.registerEPackage(subp);
        }
    }

    public static void registerEPackages(Resource r) {
        for (Object o : r.getContents()) {
            if (!(o instanceof EPackage)) continue;
            ModelUtil.registerEPackage((EPackage)o);
        }
    }

    public static Resource findResourceWithURI(String uri, ResourceSet rs) {
        return ModelUtil.findResourceWithURI(uri, (List)rs.getResources());
    }

    public static Resource findResourceWithURI(String uri, List resources) {
        int i = 0;
        while (i < resources.size()) {
            Resource r = (Resource)resources.get(i);
            if (r.getURI().toString().equals(uri)) {
                return r;
            }
            ++i;
        }
        return null;
    }

    public static EObject findObjectForID(String id, ResourceSet rs) {
        if (rs == null) {
            throw new IllegalArgumentException("ResourceSet must be specified");
        }
        EList l = rs.getResources();
        int i = 0;
        while (i < l.size()) {
            Resource r = (Resource)l.get(i);
            EObject o = r.getEObject(id);
            if (o != null) {
                return o;
            }
            ++i;
        }
        return null;
    }

    public static Set getAllProxies(Resource r) {
        HashSet<EObject> result = new HashSet<EObject>();
        TreeIterator it = r.getAllContents();
        while (it.hasNext()) {
            EObject o = (EObject)it.next();
            for (EObject o2 : o.eCrossReferences()) {
                if (!o2.eIsProxy()) continue;
                result.add(o2);
            }
        }
        return result;
    }
}

