/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.mb_xmi;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.XmiUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.mb_xmi.IdTable;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.mb_xmi.IdTableRegistry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class MBModelSerializer {
    public boolean option_omit_default_value = true;
    Set fragment = null;

    public String serializeFragment(Collection fragment) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.serializeFragment(fragment, out);
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
        return out.toString();
    }

    public void serializeFragment(Collection fragment, OutputStream out) throws IOException {
        Document doc = XmiUtil.createDocument();
        Element docElem = doc.createElementNS("http://www.omg.org/XMI", "xmi:XMI");
        docElem.setAttribute("xmlns:xmi", "http://www.omg.org/XMI");
        doc.appendChild(docElem);
        this.serializeFragment(fragment, docElem);
        XmiUtil.write(docElem, out);
    }

    public void serializeFragment(Collection fragment, Element rootElem) {
        if (fragment.isEmpty()) {
            RootLogger.getLogger().log(Level.WARNING, "fragment is empty");
            return;
        }
        this.fragment = fragment instanceof Set ? (Set)fragment : new HashSet(fragment);
        Document doc = rootElem.getOwnerDocument();
        HashSet<EObject> writtenElems = new HashSet<EObject>();
        for (EObject o : this.fragment) {
            EObject top = ModelUtil.getTopElemInFragment(o, this.fragment);
            if (writtenElems.contains(top)) continue;
            EPackage p = top.eClass().getEPackage();
            MBModelSerializer.defineNameSpace(p, rootElem);
            Element xmlElem = doc.createElement(String.valueOf(p.getNsPrefix()) + ":" + top.eClass().getName());
            rootElem.appendChild(xmlElem);
            this.serializeThisElementAndChildren(top, xmlElem);
            writtenElems.add(top);
        }
    }

    public void serializeResource(Resource r, OutputStream out) throws IOException {
        Document doc = XmiUtil.createDocument();
        Element docElem = doc.createElementNS("http://www.omg.org/XMI", "xmi:XMI");
        docElem.setAttribute("xmlns:xmi", "http://www.omg.org/XMI");
        doc.appendChild(docElem);
        this.serializeResource(r, docElem);
        XmiUtil.write(docElem, out);
    }

    public void serializeResource(Resource r, Element rootElem) {
        Iterator it = r.getContents().iterator();
        while (it.hasNext()) {
            Document doc = rootElem.getOwnerDocument();
            EObject top = (EObject)it.next();
            EPackage p = top.eClass().getEPackage();
            MBModelSerializer.defineNameSpace(p, rootElem);
            Element xmlElem = doc.createElement(String.valueOf(p.getNsPrefix()) + ":" + top.eClass().getName());
            rootElem.appendChild(xmlElem);
            this.serializeThisElementAndChildren(top, xmlElem);
        }
    }

    void serializeThisElementAndChildren(EObject o, Element xmlElem) {
        IdTable idTable = IdTableRegistry.getIdTable(o);
        String id = idTable.getOrCreateId(o);
        xmlElem.setAttributeNS("http://www.omg.org/XMI", "xmi:id", id);
        for (EAttribute a : o.eClass().getEAllAttributes()) {
            if (a.isDerived() || a.isTransient() || !a.isChangeable() || a.isVolatile()) continue;
            this.serializeAttribute(o, a, xmlElem);
        }
        for (EReference r : o.eClass().getEAllReferences()) {
            if (MBModelSerializer.omitSerialize(r)) continue;
            this.serializeReference(o, r, xmlElem);
        }
    }

    void serializeAttribute(EObject o, EAttribute a, Element xmlElem) {
        if (!a.isMany()) {
            Object value = o.eGet((EStructuralFeature)a, false);
            if (!(value == null || this.option_omit_default_value && a.getDefaultValue() != null && value.equals(a.getDefaultValue()))) {
                xmlElem.setAttribute(a.getName(), value.toString());
            }
        } else {
            List values = (List)o.eGet((EStructuralFeature)a, false);
            Document doc = xmlElem.getOwnerDocument();
            int i = 0;
            while (i < values.size()) {
                Element subXmlElem = doc.createElement(a.getName());
                Object value = values.get(i);
                Text text = doc.createTextNode(value.toString());
                subXmlElem.appendChild(text);
                xmlElem.appendChild(subXmlElem);
                ++i;
            }
        }
    }

    void serializeReference(EObject o, EReference r, Element xmlElem) {
        block6: {
            block7: {
                block4: {
                    block5: {
                        if (!r.isContainment()) break block4;
                        if (r.isMany()) break block5;
                        EObject value = (EObject)o.eGet((EStructuralFeature)r, false);
                        if (value == null || this.fragment != null && !this.fragment.contains(value)) break block6;
                        this.serializeReferenceValueAsContent(r, value, xmlElem);
                        break block6;
                    }
                    List values = (List)o.eGet((EStructuralFeature)r, false);
                    int i = 0;
                    while (i < values.size()) {
                        EObject value = (EObject)values.get(i);
                        if (this.fragment == null || this.fragment.contains(value)) {
                            this.serializeReferenceValueAsContent(r, value, xmlElem);
                        }
                        ++i;
                    }
                    break block6;
                }
                if (r.isMany()) break block7;
                EObject value = (EObject)o.eGet((EStructuralFeature)r, false);
                if (value == null || this.fragment != null && !this.fragment.contains(value)) break block6;
                this.serializeReferenceValueAsLink(o.eResource(), r, value, xmlElem);
                break block6;
            }
            List values = (List)o.eGet((EStructuralFeature)r, false);
            int i = 0;
            while (i < values.size()) {
                EObject value = (EObject)values.get(i);
                if (this.fragment == null || this.fragment.contains(value)) {
                    this.serializeReferenceValueAsLink(o.eResource(), r, value, xmlElem);
                }
                ++i;
            }
        }
    }

    void serializeReferenceValueAsLink(Resource ownerResource, EReference r, EObject value, Element containerXmlElem) {
        String href = this.getURI(ownerResource, value);
        if (href != null) {
            Element subXmlElem = containerXmlElem.getOwnerDocument().createElement(r.getName());
            MBModelSerializer.setXmiType(value.eClass(), subXmlElem);
            subXmlElem.setAttribute("href", href);
            MBModelSerializer.setXmiType(value.eClass(), subXmlElem);
            containerXmlElem.appendChild(subXmlElem);
        }
    }

    void serializeReferenceValueAsContent(EReference r, EObject value, Element containerXmlElem) {
        Element subXmlElem = containerXmlElem.getOwnerDocument().createElement(r.getName());
        containerXmlElem.appendChild(subXmlElem);
        MBModelSerializer.setXmiType(value.eClass(), subXmlElem);
        this.serializeThisElementAndChildren(value, subXmlElem);
    }

    static void setXmiType(EClass type, Element xmlElem) {
        EPackage p = type.getEPackage();
        String prefix = p.getNsPrefix();
        xmlElem.setAttribute("xmi:type", String.valueOf(prefix) + ":" + type.getName());
        MBModelSerializer.defineNameSpace(p, xmlElem);
    }

    static void defineNameSpace(EPackage p, Element xmlElem) {
        String uri = p.getNsURI();
        String prefix = p.getNsPrefix();
        Document doc = xmlElem.getOwnerDocument();
        Element root = doc.getDocumentElement();
        root.setAttribute("xmlns:" + prefix, uri);
    }

    static boolean omitSerialize(EReference r) {
        if (r.isDerived() || r.isTransient() || !r.isChangeable() || r.isContainer() || r.isVolatile()) {
            return true;
        }
        if (r.isContainment()) {
            return false;
        }
        EReference op = r.getEOpposite();
        if (op == null) {
            return false;
        }
        if (r.isOrdered()) {
            return false;
        }
        if (op.isOrdered()) {
            return true;
        }
        return r.getName().compareTo(op.getName()) < 0;
    }

    String getURI(Resource ownerResource, EObject o) {
        if (o.eIsProxy()) {
            URI uri;
            URI nUri = uri = ((InternalEObject)o).eProxyURI();
            ResourceSet rs = ownerResource.getResourceSet();
            if (rs != null) {
                nUri = rs.getURIConverter().normalize(uri);
            }
            if (ownerResource.getURI().toString().equals(nUri.trimFragment().toString())) {
                EObject v = ownerResource.getEObject(nUri.fragment());
                if (v == null || v.eResource() != ownerResource) {
                    return null;
                }
                return nUri.fragment();
            }
            return nUri.toString();
        }
        Resource targetRes = o.eResource();
        if (this.fragment != null && this.fragment.contains(o) || targetRes == null || targetRes == ownerResource) {
            IdTable idTable = IdTableRegistry.getIdTable(o);
            return idTable.getOrCreateId(o);
        }
        return String.valueOf(targetRes.getURI().toString()) + "#" + targetRes.getURIFragment(o);
    }
}

