/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.uml2;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelBusResourceSet;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.uml2.Uml2ModelUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.DefaultModelSerializer;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.DeserializedModel;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.SerializedXmiDocument;
import org.eclipse.mddi.modelbus.description.abstract_.Parameter;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfiledModelSerializer
extends DefaultModelSerializer {
    public ProfiledModelSerializer() {
        this.ignoredUriPrefixSet.add("pathmap://UML2_PROFILES");
        this.ignoredUriPrefixSet.add("pathmap://UML2_LIBRARIES");
        this.ignoredUriPrefixSet.add("pathmap://UML2_METAMODELS");
    }

    @Override
    public SerializedXmiDocument[] serialize(List<Parameter> params, Map<String, Object> values) {
        Resource r;
        Collection<EObject> allModelElements = this.getScope(params, values);
        this.sentResources = ModelUtil.getResourcesFromObjects(allModelElements, this.skipCrossReferences, this.ignoredUriPrefixSet);
        Vector<Resource> list = new Vector<Resource>(this.sentResources);
        this.sentResources.clear();
        while ((r = this.getProfileResourceFirst(list)) != null) {
            this.sentResources.add(r);
        }
        return this.serializeResources();
    }

    @Override
    public DeserializedModel[] deserialize(SerializedXmiDocument[] documents) {
        DeserializedModel[] result = new DeserializedModel[documents.length];
        ModelBusResourceSet rs = new ModelBusResourceSet();
        int i = 0;
        while (i < documents.length) {
            result[i] = new DeserializedModel();
            result[i].setUri(documents[i].getUri());
            try {
                ByteArrayInputStream bin = new ByteArrayInputStream(documents[i].getXmi().getBytes());
                Resource r = rs.createResource(URI.createURI((String)documents[i].getUri()));
                r.load((InputStream)bin, null);
                result[i].setValue(r);
                if (this.receivedResources == null) {
                    this.receivedResources = new Vector();
                }
                this.receivedResources.add(r);
                Profile p = ProfiledModelSerializer.getContainedProfile(r);
                if (p != null) {
                    Uml2ModelUtil.registerEcorePackagesOfProfile(p);
                }
            }
            catch (Exception e) {
                RootLogger.getLogger().log(Level.SEVERE, "", e);
            }
            ++i;
        }
        return result;
    }

    Resource getProfileResourceFirst(Collection<Resource> c) {
        for (Resource r : c) {
            Profile p = ProfiledModelSerializer.getContainedProfile(r);
            if (p == null) continue;
            c.remove(r);
            return r;
        }
        if (c.isEmpty()) {
            return null;
        }
        Resource r2 = c.iterator().next();
        c.remove(r2);
        return r2;
    }

    public static Profile getContainedProfile(Resource r) {
        Profile profile = (Profile)EcoreUtil.getObjectByType((Collection)r.getContents(), (EClassifier)UMLPackage.eINSTANCE.getProfile());
        return profile;
    }
}

