/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.notification;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.notification.NotifServiceClient;
import org.eclipse.mddi.modelbus.adapter.infrastructure.notification.NotifServiceNotAvailableException;
import org.eclipse.mddi.modelbus.adapter.infrastructure.notification.NotificationEndPoint;
import org.eclipse.mddi.modelbus.adapter.infrastructure.notification.NotificationProtocol;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.ServerManager;
import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;
import org.eclipse.mddi.modelbus.adapter.user.notification.NotificationConsumer;

public class NotifServiceManager {
    NotificationProtocol protocol = null;
    static NotifServiceManager instance = new NotifServiceManager();
    Map clientMap = new HashMap();
    NotificationEndPoint notificationEndPoint = null;

    public static NotifServiceManager getInstance() {
        return instance;
    }

    NotifServiceManager() {
    }

    public void subscribeNotificationConsumer(AdapterStub adapter) throws NotifServiceNotAvailableException {
        String ns_loc = adapter.getProperties().getProperty("notification_service_location");
        if (ns_loc == null) {
            return;
        }
        String topics = adapter.getProperties().getProperty("notification_service_topics");
        if (topics == null) {
            return;
        }
        this.getNotificationEndPoint();
        NotificationConsumer con = adapter.getToolStub().getNotificationConsumer();
        if (con == null) {
            RootLogger.getLogger().log(Level.WARNING, "Tool does not provide NotificationConsumer, so it can not receive notifications");
            return;
        }
        NotifServiceClient c = this.getNotificationServiceClient(ns_loc);
        int port = ServerManager.getModelBusPort(adapter);
        c.subscribeConsumer(port, con, topics);
    }

    public void unsubscribeNotificationConsumer(AdapterStub adapter) throws NotifServiceNotAvailableException {
        String ns_loc = adapter.getProperties().getProperty("notification_service_location");
        if (ns_loc == null) {
            return;
        }
        NotificationConsumer con = adapter.getToolStub().getNotificationConsumer();
        if (con == null) {
            return;
        }
        NotifServiceClient c = this.getNotificationServiceClient(ns_loc);
        c.unsubscribeConsumer(con);
    }

    public Collection getAllNotificationServiceLocations() {
        return new HashSet(this.clientMap.keySet());
    }

    public Collection getAllNotificationServiceClients() {
        return new HashSet(this.clientMap.values());
    }

    public NotifServiceClient getNotificationServiceClient(String location) throws NotifServiceNotAvailableException {
        if (this.clientMap.containsKey(location)) {
            return (NotifServiceClient)this.clientMap.get(location);
        }
        NotifServiceClient client = new NotifServiceClient(location);
        this.clientMap.put(location, client);
        return client;
    }

    public void removeRegistryClient(String location) {
        if (this.clientMap.containsKey(location)) {
            this.clientMap.remove(location);
        }
    }

    public NotificationEndPoint getNotificationEndPoint() {
        if (this.notificationEndPoint == null) {
            this.notificationEndPoint = new NotificationEndPoint();
        }
        return this.notificationEndPoint;
    }

    public NotificationProtocol getProtocol() throws NotifServiceNotAvailableException {
        if (this.protocol == null) {
            throw new NotifServiceNotAvailableException("Please initialize Protocol first [calling org.eclipse.mddi.modelbus.adapter.infrastructure.notification.NotificationProtocolImpl.init() ]", null);
        }
        return this.protocol;
    }

    public void setProtocol(NotificationProtocol protocol) {
        this.protocol = protocol;
    }
}

