/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.serialize;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.logging.Level;
import org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.DeserializedModel;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.ModelElementReference;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.ModelSerializer;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.SerializedXmiDocument;
import org.eclipse.mddi.modelbus.description.abstract_.ModelType;
import org.eclipse.mddi.modelbus.description.abstract_.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBasicModelSerializer
implements ModelSerializer {
    protected Map model_uri = new WeakHashMap();
    protected DeserializedModel[] models;

    @Override
    public SerializedXmiDocument[] serialize(List<Parameter> params, Map<String, Object> values) {
        Vector<SerializedXmiDocument> docVector = new Vector<SerializedXmiDocument>();
        for (Parameter p : params) {
            if (!(p.getType() instanceof ModelType)) continue;
            Object value = values.get(p.getName());
            if (p.getUpper() != 1) {
                Object[] array = (Object[])value;
                int j = 0;
                while (j < array.length) {
                    SerializedXmiDocument doc = this.serializeDocument(String.valueOf(p.getName()) + "." + j, array[j]);
                    docVector.add(doc);
                    ++j;
                }
                continue;
            }
            SerializedXmiDocument doc = this.serializeDocument(p.getName(), value);
            docVector.add(doc);
        }
        return docVector.toArray(new SerializedXmiDocument[docVector.size()]);
    }

    protected SerializedXmiDocument serializeDocument(String uri, Object value) {
        SerializedXmiDocument doc = new SerializedXmiDocument();
        doc.setUri(uri);
        this.model_uri.put(value, uri);
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.serialize(value, out);
            doc.setXmi(out.toString());
        }
        catch (Exception e) {
            RootLogger.getLogger().log(Level.SEVERE, "", e);
            e.printStackTrace();
        }
        return doc;
    }

    protected abstract void serialize(Object var1, OutputStream var2);

    @Override
    public DeserializedModel[] deserialize(SerializedXmiDocument[] documents) {
        this.models = new DeserializedModel[documents.length];
        int i = 0;
        while (i < documents.length) {
            this.models[i] = new DeserializedModel();
            this.models[i].setUri(documents[i].getUri());
            try {
                ByteArrayInputStream bin = new ByteArrayInputStream(documents[i].getXmi().getBytes());
                Object o = this.deserialize(bin);
                this.models[i].setValue(o);
            }
            catch (Exception e) {
                RootLogger.getLogger().log(Level.SEVERE, "", e);
                e.printStackTrace();
            }
            ++i;
        }
        return this.models;
    }

    protected abstract Object deserialize(InputStream var1);

    @Override
    public ModelElementReference[] getReferences(Parameter p, Object o) {
        ModelElementReference[] result = new ModelElementReference[]{new ModelElementReference()};
        result[0].setUri((String)this.model_uri.get(o));
        result[0].setRef("/");
        return result;
    }

    @Override
    public Object dereference(Parameter p, ModelElementReference[] refs) {
        new Vector();
        String uri = refs[0].getUri();
        int j = 0;
        while (j < this.models.length) {
            if (this.models[j].getUri().equals(uri)) {
                return this.models[j].getValue();
            }
            ++j;
        }
        RootLogger.getLogger().log(Level.SEVERE, "Resource Not Found " + uri);
        return null;
    }
}

