/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws;

import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.DescriptionUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.ModelSerializerFactory;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.RepositoryClient;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.DefaultMarshaler;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.SoapUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.WsInvocationReceiver;
import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;
import org.eclipse.mddi.modelbus.adapter.user.InvalidSession;
import org.eclipse.mddi.modelbus.adapter.user.ModelingServiceError;
import org.eclipse.mddi.modelbus.adapter.user.SessionNeeded;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingService;
import org.eclipse.mddi.modelbus.description.abstract_.Parameter;

public class DefaultWsInvocationReceiver
extends WsInvocationReceiver {
    AdapterStub adapter;
    SOAPEnvelope reqMsg;
    SOAPEnvelope resMsg;
    ModelingService ms;
    Map inputs;
    Map outputs;

    public DefaultWsInvocationReceiver(AdapterStub adapter) {
        this.adapter = adapter;
        this.setMarshaler(new DefaultMarshaler());
        RepositoryClient client = new RepositoryClient(adapter.getGenericConsumer());
        this.getMarshaler().setRepositoryClient(client);
    }

    public void process(SOAPEnvelope reqMsg, SOAPEnvelope resMsg) {
        this.reqMsg = reqMsg;
        this.resMsg = resMsg;
        try {
            this.readRequest();
            this.performService();
            this.createResponse();
        }
        catch (Exception e) {
            try {
                this.createSoapFault(resMsg, e);
            }
            catch (SOAPException e1) {
                e1.printStackTrace();
            }
        }
    }

    public void readRequest() throws Exception {
        SOAPBody requestbody = this.reqMsg.getBody();
        SOAPElement reqTopElem = SoapUtil.getFirstChild((SOAPElement)requestbody);
        if (reqTopElem == null) {
            RootLogger.getLogger().log(Level.SEVERE, "SERVER: received empty request");
            RootLogger.getLogger().log(Level.INFO, this.reqMsg.toString());
            throw new SOAPException("Empty SOAP request");
        }
        ModelSerializerFactory f = this.adapter.getTransportManager().findModelSerializerFactory(reqTopElem.getAttribute("modelbus:modelSerializer"));
        this.getMarshaler().setModelSerializerFactory(f);
        String serviceName = reqTopElem.getLocalName();
        this.ms = DescriptionUtil.getServiceDescription(serviceName, this.adapter.getToolDescription());
        if (this.ms == null) {
            throw new SOAPException("Service unknown - " + serviceName);
        }
        List<Parameter> params = DescriptionUtil.get_in_inout_Parameters(this.ms);
        this.inputs = this.marshaler.unmarshal(params, reqTopElem);
    }

    public void performService() throws SessionNeeded, ModelingServiceError, InvalidSession {
        this.adapter.getToolStub().getProvider();
        String serviceName = this.ms.getName();
        if (this.adapter.getToolStub().getProvider() != null) {
            Parameter[] inputParams = DescriptionUtil.get_in_inout_Parameters(this.ms).toArray(new Parameter[0]);
            Parameter[] outputParams = DescriptionUtil.get_out_inout_Parameters(this.ms).toArray(new Parameter[0]);
            Object[] inputArray = DescriptionUtil.map2Array(inputParams, this.inputs);
            Object[] outputArray = this.adapter.getToolStub().getProvider().execute(serviceName, inputArray);
            this.outputs = DescriptionUtil.array2Map(outputParams, outputArray);
        } else if (this.adapter.getToolStub().getProvider2() != null) {
            this.outputs = this.adapter.getToolStub().getProvider2().execute(serviceName, this.inputs);
        } else {
            RootLogger.getLogger().log(Level.SEVERE, "No Provider object found for tool " + this.adapter.getToolDescription());
            throw new ModelingServiceError("Config problem", (Object)("No tool impl for " + this.adapter.getToolDescription()));
        }
    }

    public void createResponse() throws Exception {
        SOAPBody responsebody = this.resMsg.getBody();
        DefaultMarshaler.setNamespaces(responsebody);
        SOAPElement resTopElem = responsebody.addChildElement(String.valueOf(this.ms.getName()) + "Response", "modelbus");
        List<Parameter> params = DescriptionUtil.get_out_inout_Parameters(this.ms);
        this.marshaler.marshal(params, this.outputs, resTopElem);
    }

    public void createSoapFault(SOAPEnvelope resMsg, Exception cause) throws SOAPException {
        ModelingServiceError err;
        SOAPBody responsebody = resMsg.getBody();
        DefaultMarshaler.setNamespaces(responsebody);
        SOAPFault f = responsebody.addFault();
        if (cause instanceof ModelingServiceError) {
            RootLogger.getLogger().log(Level.INFO, "Creating Soap fault for ModelingServiceError " + cause.getMessage());
            err = (ModelingServiceError)cause;
        } else {
            RootLogger.getLogger().log(Level.SEVERE, "Creating Soap fault for runtime exception ", cause);
            err = new ModelingServiceError("Runtime error at Server ", (Object)cause.toString());
        }
        this.marshaler.marshalModelingServiceError(err, f);
    }

    public static void createSimpleSoapFault(SOAPEnvelope resMsg, Exception cause) throws SOAPException {
        SOAPBody responsebody = resMsg.getBody();
        DefaultMarshaler.setNamespaces(responsebody);
        SOAPFault f = responsebody.addFault();
        f.setFaultString(cause.getClass() + ":" + cause.getMessage());
        RootLogger.getLogger().log(Level.SEVERE, "Error", cause);
    }

    public static void createSoapFault(SOAPEnvelope resMsg, String errMessage) throws SOAPException {
        SOAPBody responsebody = resMsg.getBody();
        DefaultMarshaler.setNamespaces(responsebody);
        SOAPFault f = responsebody.addFault();
        f.setFaultCode("modelbus:ServerError");
        f.setFaultString(errMessage);
        RootLogger.getLogger().log(Level.SEVERE, "modelbus:ServerError. " + errMessage);
    }
}

